/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BDynamicEnum
extends BEnum
implements BIDataValue {
    public static final BDynamicEnum DEFAULT = BDynamicEnum.make(0);
    public static final Type TYPE = Sys.loadType(BDynamicEnum.class);
    private int ordinal;
    private BEnumRange range;
    private String string;
    private int hashCode = -1;

    public static BDynamicEnum make(int ordinal, BEnumRange range) {
        if (range == null) {
            range = BEnumRange.NULL;
        }
        return (BDynamicEnum)new BDynamicEnum(ordinal, range).intern();
    }

    public static BDynamicEnum make(int ordinal) {
        return BDynamicEnum.make(ordinal, BEnumRange.NULL);
    }

    public static BDynamicEnum make(BEnum e) {
        if (e instanceof BDynamicEnum) {
            return (BDynamicEnum)e;
        }
        if (e instanceof BFrozenEnum) {
            BFrozenEnum frozen = (BFrozenEnum)e;
            if (frozen.asDynamic == null) {
                frozen.asDynamic = BDynamicEnum.make(e.getOrdinal(), e.getRange());
            }
            return frozen.asDynamic;
        }
        if (e instanceof BBoolean) {
            BBoolean bool = (BBoolean)e;
            if (bool.asDynamic == null) {
                bool.asDynamic = BDynamicEnum.make(e.getOrdinal(), e.getRange());
            }
            return bool.asDynamic;
        }
        throw new IllegalStateException();
    }

    public static BDynamicEnum make(BEnumRange range) {
        int[] ordinals = range.getOrdinals();
        int defaultOrdinal = ordinals == null || ordinals.length == 0 ? 0 : ordinals[0];
        return BDynamicEnum.make(defaultOrdinal, range);
    }

    private BDynamicEnum(int ordinal, BEnumRange range) {
        this.ordinal = ordinal;
        this.range = range;
    }

    @Override
    public boolean isActive() {
        return this.ordinal != 0;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getTag() {
        return this.range.getTag(this.ordinal);
    }

    @Override
    public String getDisplayTag(Context cx) {
        return this.range.getDisplayTag(this.ordinal, cx);
    }

    @Override
    public BEnumRange getRange() {
        return this.range;
    }

    @Override
    public String toString(Context context) {
        BEnumRange r;
        if (context != null && (r = (BEnumRange)context.getFacet("range")) != null) {
            return r.getDisplayTag(this.ordinal, context);
        }
        return this.getDisplayTag(context);
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BDynamicEnum) {
            BDynamicEnum x = (BDynamicEnum)o;
            if (this.ordinal != x.ordinal) {
                return false;
            }
            return this.range.equals(x.range);
        }
        return false;
    }

    @Override
    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public final String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            s.append(this.ordinal);
            if (!this.range.isNull()) {
                s.append('@');
                s.append(this.range.encodeToString());
            }
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public final BObject decodeFromString(String s) throws IOException {
        try {
            String o = s;
            String r = null;
            int at = s.indexOf(64);
            if (at > 0) {
                o = s.substring(0, at);
                r = s.substring(at + 1);
            }
            int ordinal = Integer.parseInt(o);
            BEnumRange range = BEnumRange.NULL;
            if (r != null) {
                range = (BEnumRange)range.decodeFromString(r);
            }
            BDynamicEnum result = BDynamicEnum.make(ordinal, range);
            result.string = s;
            return result;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(s);
        }
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

