/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractService
extends BComponent
implements BIService,
BIStatus,
BILicensed {
    public static final Property status = BAbstractService.newProperty(3, BStatus.ok, null);
    public static final Property faultCause = BAbstractService.newProperty(3, "", null);
    public static final Property enabled = BAbstractService.newProperty(0, true, null);
    public static final Type TYPE = Sys.loadType(BAbstractService.class);
    private boolean fatalFault;
    private boolean configFault;
    private static HashMap<String, HashMap<String, LicenseLimit>> globalLimits = new HashMap();
    private HashMap<String, LicenseLimit> limits;

    @Override
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void serviceStarted() throws Exception {
    }

    @Override
    public void serviceStopped() throws Exception {
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isOperational() {
        BStatus status = this.getStatus();
        return !this.isFatalFault() && !status.isDisabled() && !status.isFault();
    }

    public void updateStatus() {
        boolean newEnabled;
        boolean oldEnabled = !this.isDisabled();
        int oldStatus = this.getStatus().getBits();
        int newStatus = 0;
        newStatus = !this.getEnabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.fatalFault || this.configFault ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make(newStatus));
        boolean bl = newEnabled = !this.isDisabled();
        if (oldEnabled != newEnabled) {
            if (newEnabled) {
                this.enabled();
            } else {
                this.disabled();
            }
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String cause) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.setFaultCause(cause);
        this.updateStatus();
    }

    @Override
    public Feature getLicenseFeature() {
        return null;
    }

    private void checkLicense() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature == null) {
                return;
            }
            feature.check();
            String globalKey = feature.getVendorName() + ":" + feature.getFeatureName();
            globalKey = TextUtil.toLowerCase((String)globalKey);
            this.limits = globalLimits.get(globalKey);
            if (this.limits != null) {
                return;
            }
            this.limits = new HashMap();
            globalLimits.put(globalKey, this.limits);
            for (String key : feature.list()) {
                if (!key.endsWith(".limit")) continue;
                String val = feature.get(key);
                int limit = Integer.MAX_VALUE;
                if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
                    limit = Integer.parseInt(val);
                }
                LicenseLimit lic = new LicenseLimit();
                lic.key = key;
                lic.used = 0;
                lic.limit = limit;
                this.limits.put(key, lic);
            }
        }
        catch (Exception e) {
            this.fatalFault = true;
            Logger.getLogger("service").log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
            this.setFaultCause("Unlicensed: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLicenseCount(String key) {
        if (this.limits == null) {
            return 0;
        }
        HashMap<String, LicenseLimit> hashMap = this.limits;
        synchronized (hashMap) {
            LicenseLimit lic = this.limits.get(key);
            if (lic == null) {
                return 0;
            }
            return lic.used;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkLicenseLimit(String key) {
        if (this.limits == null) {
            return null;
        }
        HashMap<String, LicenseLimit> hashMap = this.limits;
        synchronized (hashMap) {
            LicenseLimit lic = this.limits.get(key);
            if (lic == null) {
                return "Unlicensed: " + key;
            }
            ++lic.used;
            if (lic.used > lic.limit) {
                return "Exceeded " + lic.key + " of " + lic.limit;
            }
            return null;
        }
    }

    protected void enabled() {
    }

    protected void disabled() {
    }

    @Override
    public void checkSetFlags(Slot slot, int flags, Context context) {
        super.checkSetFlags(slot, flags, context);
        if (context != Context.decoding && (slot.equals(status) || slot.equals(faultCause)) && (1 & flags) != 1) {
            throw new LocalizableRuntimeException("baja", "cannotChangeReadOnly", new Object[]{slot.getName()});
        }
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 15: {
                this.fwServiceStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 12: {
                this.updateStatus();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 501: {
                return this.checkLicenseLimit((String)a);
            }
            case 503: {
                return this.getLicenseCount((String)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwServiceStarted() {
        this.checkLicense();
        this.updateStatus();
    }

    private void fwDescendantsStarted() {
        this.updateStatus();
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled)) {
            this.updateStatus();
        }
        if (prop.equals(status) && !this.getStatus().isFault() && this.fatalFault) {
            this.updateStatus();
        }
    }

    static class LicenseLimit {
        String key;
        int limit;
        int used;

        LicenseLimit() {
        }
    }
}

