/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public abstract class Transaction
extends SyncBuffer
implements Context {
    private final Context baseContext;
    private final BFacets facets;

    public static Context start(BComponent c, Context baseContext) {
        BComponentSpace space = c.getComponentSpace();
        if (space != null) {
            return space.newTransaction(baseContext);
        }
        return baseContext;
    }

    public static void end(BComponent c, Context context) throws Exception {
        if (context instanceof Transaction) {
            Transaction tx = (Transaction)context;
            tx.commit(tx.baseContext);
        }
    }

    protected Transaction(BComponentSpace space, Context baseContext) {
        this(space, baseContext, BFacets.NULL);
    }

    protected Transaction(BComponentSpace space, Context baseContext, BFacets additionalFacets) {
        super(space, false);
        if (baseContext instanceof Transaction) {
            throw new IllegalStateException("Nested transactions not supported");
        }
        this.baseContext = baseContext == null ? new BasicContext() : baseContext;
        this.facets = additionalFacets == null ? this.baseContext.getFacets() : BFacets.make(this.baseContext.getFacets(), additionalFacets);
    }

    @Override
    public Context getBase() {
        return this.baseContext;
    }

    @Override
    public BUser getUser() {
        return this.baseContext.getUser();
    }

    @Override
    public BFacets getFacets() {
        return this.facets;
    }

    @Override
    public BObject getFacet(String name) {
        return this.facets.getFacet(name);
    }

    @Override
    public String getLanguage() {
        return this.baseContext.getLanguage();
    }
}

