/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferStrategy;
import java.util.HashMap;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddOp;
import javax.baja.sync.BatchSetOp;
import javax.baja.sync.LoadOp;
import javax.baja.sync.RemoveOp;
import javax.baja.sync.RenameOp;
import javax.baja.sync.ReorderOp;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class SyncBuffer {
    static BFacets noAutoStartFacets;
    BComponentSpace space;
    OpLinkedList loads;
    OpLinkedList ops;
    boolean coalesce;
    Map<BComponent, Map<String, SyncOp>> propChanges;
    TransferListener listener;
    private int id = -1;
    boolean checkForAutoStart = true;

    public SyncBuffer(BComponentSpace space, boolean coalesce) {
        this.space = space;
        this.loads = new OpLinkedList();
        this.ops = new OpLinkedList();
        this.coalesce = coalesce;
        if (coalesce) {
            this.propChanges = new HashMap<BComponent, Map<String, SyncOp>>();
        }
    }

    public BComponentSpace getSpace() {
        return this.space;
    }

    public boolean isCoalesced() {
        return this.coalesce;
    }

    public void encode(SyncEncoder out) throws Exception {
        out.start("sync").attr("ver", "1.0");
        if (this.id > -1) {
            out.attr("id", this.id);
        }
        out.endAttr().newLine();
        out.startArray("ops");
        SyncOp[] ops = this.list();
        for (int i = 0; i < ops.length; ++i) {
            try {
                ops[i].encode(out);
                continue;
            }
            catch (SyncOp.SyncOpSecurityException syncOpSecurityException) {
                // empty catch block
            }
        }
        out.endArray();
        out.end("sync").newLine();
    }

    public void decode(SyncDecoder in) throws Exception {
        if (this.loads.head != null || this.ops.head != null) {
            throw new IllegalStateException("Already contains changes");
        }
        IElement root = in.elem();
        if (root == null) {
            in.next();
            root = in.elem();
        }
        if (root == null) {
            return;
        }
        if (!root.name().equals("sync")) {
            throw in.err("Invalid root element " + root.name());
        }
        this.id = root.geti("id", -1);
        while (true) {
            int ptype;
            if ((ptype = in.next()) == 2) {
                if (in.elem().name().equals("sync")) break;
                throw in.err("Expected end sync");
            }
            if (ptype != 1) {
                throw in.err("Expected element start");
            }
            int depth = in.depth();
            IElement elem = in.elem();
            char id = elem.name().charAt(0);
            SyncOp change = SyncOp.make(id);
            change.decode(this, this.space, in);
            this.add(change);
            in.skip(depth);
        }
    }

    public final void commit() throws Exception {
        this.commit(null);
    }

    protected SyncOp[] startCommit(SyncOp[] ops, Context cx) {
        return ops;
    }

    protected void endCommit() throws Exception {
    }

    protected void abortCommit(Exception cause) {
    }

    public void commit(Context context) throws Exception {
        SyncOp[] ops = this.startCommit(this.list(), context);
        try {
            int i;
            Context commitContext = context;
            if (!this.space.isProxyComponentSpace()) {
                commitContext = new BasicContext(context, noAutoStartFacets);
            }
            for (i = 0; i < ops.length; ++i) {
                if (ops[i].committed) continue;
                this.commitOp(ops[i], commitContext);
            }
            if (this.checkForAutoStart) {
                this.checkForAutoStart = false;
                for (i = 0; i < ops.length; ++i) {
                    try {
                        SyncOp op = ops[i];
                        if (op instanceof AddOp) {
                            this.checkAutoStart(((AddOp)op).value);
                        }
                        if (op instanceof SetOp) {
                            this.checkAutoStart(((SetOp)op).value);
                        }
                        if (!(op instanceof BatchSetOp)) continue;
                        ((BatchSetOp)op).setOps.forEach(setOp -> this.checkAutoStart(setOp.value));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.endCommit();
        }
        catch (Exception ex) {
            this.abortCommit(ex);
            throw ex;
        }
    }

    protected void commitOp(SyncOp op, Context cx) throws Exception {
        block7: {
            try {
                if (op.committed) {
                    return;
                }
                op.committed = true;
                if (op.component == null) {
                    try {
                        op.component = this.findByHandle(op.handle, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (op.component != null) {
                    op.commit(this, this.space, cx);
                }
            }
            catch (Exception e) {
                System.out.println("ERROR: SyncOp.commit: " + op);
                e.printStackTrace();
                if (this.space.isProxyComponentSpace()) break block7;
                throw e;
            }
        }
    }

    protected void checkAutoStart(BValue value) {
        BComponent comp;
        BComponent parent;
        if (value instanceof BComponent && (parent = (BComponent)(comp = (BComponent)value).getParent()) != null && parent.isRunning()) {
            if (this.listener != null) {
                this.listener.updateStatus("Starting \"" + TransferStrategy.toString(comp) + "\"...");
            }
            comp.start();
        }
    }

    protected BComponent findByHandle(Object handle, boolean autoLoad) {
        return this.space.findByHandle(handle, autoLoad);
    }

    public void set(BComponent c, Property[] propertyPath, BValue value, Context context) {
        String name;
        if (this.coalesce) {
            this.add(new SetOp(c, propertyPath[0].getName(), null));
            return;
        }
        if (propertyPath.length == 1) {
            name = propertyPath[0].getName();
        } else {
            StringBuffer s = new StringBuffer(propertyPath[0].getName());
            for (int i = 1; i < propertyPath.length; ++i) {
                s.append('/').append(propertyPath[i].getName());
            }
            name = s.toString();
        }
        this.add(new SetOp(c, name, value));
    }

    public void add(BComponent c, String name, BValue value, int flags, BFacets facets, Context context) {
        this.add(new AddOp(c, name, value, flags, facets));
    }

    public void remove(BComponent c, Property prop, Context context) {
        this.add(new RemoveOp(c, prop.getName()));
    }

    public void rename(BComponent c, Property prop, String newName, Context context) {
        this.add(new RenameOp(c, prop.getName(), newName));
    }

    public void reorder(BComponent c, Property[] order, Context context) {
        String[] names = new String[order.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = order[i].getName();
        }
        this.add(new ReorderOp(c, names));
    }

    public void setFlags(BComponent c, Slot slot, int flags, Context context) {
        this.add(new SetFlagsOp(c, slot.getName(), flags));
    }

    public void setFacets(BComponent c, Slot slot, BFacets facets, Context context) {
        this.add(new SetFacetsOp(c, slot.getName(), facets));
    }

    public void setCategoryMask(BComponent c, BCategoryMask mask, Context context) {
        this.add(new SetCategoryMaskOp(c, mask));
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public synchronized SyncOp[] list() {
        SyncOp[] r = new SyncOp[this.loads.size + this.ops.size];
        int i = 0;
        SyncOp p = this.loads.head;
        while (p != null) {
            r[i] = p;
            p = p.next;
            ++i;
        }
        p = this.ops.head;
        while (p != null) {
            r[i] = p;
            p = p.next;
            ++i;
        }
        return r;
    }

    public synchronized void add(SyncOp op) {
        if (op.prev != null || op.next != null) {
            throw new IllegalStateException("Already in linked list " + op);
        }
        if (op instanceof SetOp) {
            if (this.coalesce) {
                this.coalesceSet((SetOp)op);
            } else {
                this.appendSet((SetOp)op);
            }
        } else if (op instanceof LoadOp) {
            this.loads.append(op);
        } else {
            this.ops.append(op);
        }
    }

    private void coalesceSet(SetOp op) {
        BatchSetOp batch;
        BComponent component = op.component;
        String name = op.name;
        Map<String, SyncOp> props = this.propChanges.get(component);
        if (props != null) {
            SyncOp old = props.get(name);
            if (old != null) {
                if (old instanceof SetOp) {
                    this.ops.remove(old);
                } else {
                    batch = (BatchSetOp)old;
                    batch.setOps.removeIf(setOp -> setOp != null && setOp.name.equals(name));
                    if (batch.size() <= 0) {
                        this.ops.remove(old);
                    }
                }
            }
        } else {
            props = new HashMap<String, SyncOp>(13);
            this.propChanges.put(component, props);
        }
        SyncOp committedOp = this.appendSet(op);
        if (committedOp instanceof SetOp) {
            props.put(name, committedOp);
        } else {
            batch = (BatchSetOp)committedOp;
            for (SetOp setOp2 : batch.setOps) {
                props.put(setOp2.name, committedOp);
            }
        }
    }

    private SyncOp appendSet(SetOp op) {
        SyncOp lastSet;
        SyncOp lastOp = this.ops.tail;
        BComplex target = null;
        BComponent comp = null;
        boolean isSetOp = lastOp instanceof SetOp;
        if (isSetOp) {
            lastSet = (SetOp)lastOp;
            comp = lastSet.getComponent();
            if (comp != null) {
                try {
                    target = ((SetOp)lastSet).getTarget();
                }
                catch (IllegalStateException ise) {
                    this.ops.append(op);
                    return op;
                }
            }
        } else if (lastOp instanceof BatchSetOp && (comp = (lastSet = (BatchSetOp)lastOp).getComponent()) != null) {
            target = ((BatchSetOp)lastSet).getTarget();
        }
        if (target != null && comp != null && comp == op.getComponent() && target == op.getTarget()) {
            BatchSetOp batchSetOp = null;
            if (isSetOp) {
                batchSetOp = new BatchSetOp(comp, new SetOp[]{(SetOp)lastOp, op});
                this.ops.replace(lastOp, batchSetOp);
            } else {
                batchSetOp = (BatchSetOp)lastOp;
                batchSetOp.addSet(op);
            }
            return batchSetOp;
        }
        this.ops.append(op);
        return op;
    }

    public void fw(Object a) {
        if (a instanceof TransferListener) {
            this.listener = (TransferListener)a;
        }
    }

    static {
        HashMap<String, BBoolean> map = new HashMap<String, BBoolean>();
        map.put("niagaraAutoStart", BBoolean.FALSE);
        noAutoStartFacets = BFacets.make(map);
    }

    static class OpLinkedList {
        SyncOp head;
        SyncOp tail;
        int size;

        OpLinkedList() {
        }

        void append(SyncOp op) {
            if (this.tail == null) {
                this.head = this.tail = op;
            } else {
                this.tail.next = op;
                op.prev = this.tail;
                this.tail = op;
            }
            ++this.size;
        }

        void remove(SyncOp op) {
            SyncOp prev = op.prev;
            SyncOp next = op.next;
            if (prev != null) {
                prev.next = next;
            } else {
                this.head = next;
            }
            if (next != null) {
                next.prev = prev;
            } else {
                this.tail = prev;
            }
            --this.size;
        }

        void replace(SyncOp oldOp, SyncOp newOp) {
            newOp.prev = oldOp.prev;
            newOp.next = oldOp.next;
            if (oldOp.prev != null) {
                oldOp.prev.next = newOp;
            } else {
                this.head = newOp;
            }
            if (oldOp.next != null) {
                oldOp.next.prev = newOp;
            } else {
                this.tail = newOp;
            }
        }
    }
}

