/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class SetOp
extends SyncOp {
    String name;
    BValue value;
    BComplex target;
    Property property;
    private BAbsTime timestamp;
    private int depth;

    public SetOp(BComponent c, String name, BValue value) {
        this(c, name, value, Integer.MAX_VALUE);
    }

    public SetOp(BComponent c, String name, BValue value, int depth) {
        super(c);
        this.name = name;
        this.value = value;
        this.timestamp = BAbsTime.now();
        this.depth = depth;
    }

    public SetOp() {
    }

    @Override
    public int getId() {
        return 115;
    }

    public String getSlotName() {
        return this.name;
    }

    public BValue getValue() {
        return this.value;
    }

    public BAbsTime getTimestamp() {
        return this.timestamp;
    }

    BComplex getTarget() {
        if (this.target == null) {
            String curName;
            String path;
            block5: {
                this.target = this.component;
                curName = path = this.name;
                int index = 0;
                do {
                    int slash;
                    if ((slash = this.name.indexOf(47, index)) < 0) {
                        if (index > 0) {
                            curName = path.substring(index);
                        }
                        break block5;
                    }
                    curName = path.substring(index, slash);
                    index = slash + 1;
                    this.target = (BComplex)this.target.get(curName);
                } while (this.target != null);
                throw new IllegalStateException("Missing property " + path);
            }
            this.property = this.target.getProperty(curName);
            if (this.property == null) {
                throw new IllegalStateException("Missing property " + path);
            }
        }
        return this.target;
    }

    Property getProperty() {
        if (this.property == null) {
            this.getTarget();
        }
        return this.property;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        if (this.getProperty() == null) {
            this.target = null;
        }
        this.getTarget().set(this.getProperty(), this.value, context);
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        BValue v = this.value;
        if (v == null) {
            v = this.component.get(this.name);
        }
        if (v == null) {
            System.out.println("WARNING: SetOp null value: " + this.name);
            return;
        }
        if (v.isComponent()) {
            BPermissions permissions = out.getPermissionsFor(v.asComponent());
            if (!permissions.hasOperatorRead()) {
                throw new SyncOp.SyncOpSecurityException("Missing op read permission on component");
            }
        } else {
            Slot slot;
            String propName = this.name;
            int index = propName.indexOf("/");
            if (index > -1) {
                propName = propName.substring(0, index);
            }
            if ((slot = this.component.getSlot(propName)) != null && slot instanceof Property) {
                Property prop = (Property)slot;
                BPermissions permissions = out.getPermissionsFor(this.component);
                int flags = this.component.getFlags(prop);
                if ((flags & 0x100) != 0) {
                    if (!permissions.has(BPermissions.operatorRead)) {
                        throw new SyncOp.SyncOpSecurityException("Missing op read permission on value");
                    }
                } else if (!permissions.has(BPermissions.adminRead)) {
                    throw new SyncOp.SyncOpSecurityException("Missing admin read permission on value");
                }
            }
        }
        super.encode(out);
        out.attr("n", this.name).endAttr().newLine().key("b");
        out.encode(null, v, this.depth);
        out.end(String.valueOf((char)this.getId())).newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        this.name = in.elem().get("n");
        in.next();
        this.value = in.decode();
    }

    @Override
    public String toString() {
        return "Set: " + this.componentToString() + "." + this.name + " -> " + this.value;
    }
}

