/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;

public class SetFlagsOp
extends SyncOp {
    String name;
    int flags;

    public SetFlagsOp(BComponent c, String name, int flags) {
        super(c);
        this.name = name;
        this.flags = flags;
    }

    public SetFlagsOp() {
    }

    @Override
    public int getId() {
        return 102;
    }

    public String getSlotName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        this.component.setFlags(this.component.getSlot(this.name), this.flags, context);
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        out.attr("n", this.name);
        out.attr("f", Flags.encodeToString(this.flags)).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        IElement elem = in.elem();
        this.name = elem.get("n");
        this.flags = Flags.decodeFromString(elem.get("f"));
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("SetFlags: ").append(this.componentToString()).append('.').append(this.name).append(" -> ").append(Flags.encodeToString(this.flags));
        return s.toString();
    }
}

