/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class ReorderOp
extends SyncOp {
    String[] order;

    public ReorderOp(BComponent c, String[] order) {
        super(c);
        this.order = order;
    }

    public ReorderOp() {
    }

    @Override
    public int getId() {
        return 111;
    }

    public String[] getOrder() {
        return (String[])this.order.clone();
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        block3: {
            Property[] props = new Property[this.order.length];
            for (int i = 0; i < props.length; ++i) {
                props[i] = this.component.getProperty(this.order[i]);
            }
            try {
                this.component.reorder(props, context);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (!this.component.isSubscribed()) break block3;
                throw e;
            }
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.order.length; ++i) {
            if (i > 0) {
                buff.append(';');
            }
            buff.append(this.order[i]);
        }
        out.attr("o", buff.toString()).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        String list = in.elem().get("o");
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(list, ";");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        this.order = v.toArray(new String[v.size()]);
    }

    @Override
    public String toString() {
        return "Reorder: " + this.componentToString();
    }
}

