/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import com.tridium.sys.engine.NRelationKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.RelationKnob;

public class RemoveRelationKnobOp
extends SyncOp {
    RelationKnob knob;

    public RemoveRelationKnobOp(BComponent c, RelationKnob knob) {
        super(c);
        this.knob = knob;
    }

    public RemoveRelationKnobOp() {
    }

    @Override
    public int getId() {
        return 110;
    }

    public RelationKnob getRelationKnob() {
        return this.knob;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        if (this.knob != null) {
            ((ComponentSlotMap)this.component.fw(1)).uninstallRelationKnob((NRelationKnob)this.knob);
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        NRelationKnob knob = (NRelationKnob)this.knob;
        out.attr("id", String.valueOf(knob.id)).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        if (this.component == null) {
            return;
        }
        IElement elem = in.elem();
        int id = elem.geti("id");
        NRelationKnob[] knobs = (NRelationKnob[])this.component.getRelationKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            if (knobs[i].id != id) continue;
            this.knob = knobs[i];
            break;
        }
    }

    @Override
    public String toString() {
        return "RemoveKnob: " + this.componentToString() + " " + this.knob;
    }
}

