/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import java.util.ArrayList;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

class BatchSetOp
extends SyncOp {
    ArrayList<SetOp> setOps;

    public BatchSetOp(BComponent c, SetOp[] setOps) {
        super(c);
        this.setOps = new ArrayList(setOps.length);
        for (SetOp setOp : setOps) {
            this.addSet(setOp);
        }
    }

    BComplex getTarget() {
        return this.setOps.get(0).getTarget();
    }

    void addSet(SetOp op) {
        this.setOps.add(op);
    }

    void removeSet(SetOp op) {
        this.setOps.remove(op);
    }

    int size() {
        return this.setOps.size();
    }

    @Override
    public int getId() {
        return 115;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        int len = this.setOps.size();
        if (len <= 0) {
            return;
        }
        Property[] properties = new Property[len];
        BValue[] values = new BValue[len];
        for (int i = 0; i < len; ++i) {
            SetOp op = this.setOps.get(i);
            properties[i] = op.getProperty();
            values[i] = op.getValue();
        }
        this.getTarget().set(properties, values, context);
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        Exception e = null;
        for (SetOp setOp : this.setOps) {
            try {
                setOp.encode(out);
            }
            catch (SyncOp.SyncOpSecurityException syncOpSecurityException) {
            }
            catch (Exception ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        throw new UnsupportedOperationException("BatchSetOp.decode should never be called.");
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("BatchSet: ");
        for (int i = 0; i < this.setOps.size(); ++i) {
            SetOp op = this.setOps.get(i);
            if (i > 0) {
                s.append("\n          ");
            }
            s.append(op.componentToString()).append('.').append(op.getSlotName()).append(" -> ").append(op.getValue());
        }
        return s.toString();
    }
}

