/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.status;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.status.BIStatus;
import javax.baja.sys.BBitString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;

public final class BStatus
extends BBitString
implements BIStatus {
    public static BSimple disabledFg;
    public static BSimple disabledBg;
    public static BSimple faultFg;
    public static BSimple faultBg;
    public static BSimple downFg;
    public static BSimple downBg;
    public static BSimple alarmFg;
    public static BSimple alarmBg;
    public static BSimple staleFg;
    public static BSimple staleBg;
    public static BSimple overriddenFg;
    public static BSimple overriddenBg;
    private static BStatus[] nullLookupTable;
    public static final int DISABLED = 1;
    public static final int FAULT = 2;
    public static final int DOWN = 4;
    public static final int ALARM = 8;
    public static final int STALE = 16;
    public static final int OVERRIDDEN = 32;
    public static final int NULL = 64;
    public static final int UNACKED_ALARM = 128;
    public static final BStatus ok;
    public static final BStatus disabled;
    public static final BStatus fault;
    public static final BStatus down;
    public static final BStatus alarm;
    public static final BStatus stale;
    public static final BStatus overridden;
    public static final BStatus nullStatus;
    public static final BStatus unackedAlarm;
    public static final BStatus DEFAULT;
    private static BBitString.Support support;
    public static final String ACTIVE_LEVEL = "activeLevel";
    public static final Type TYPE;
    private int bits;
    private BFacets facets;
    private int hashCode = -1;

    public static BStatus make(int bits) {
        return BStatus.make(bits, BFacets.NULL);
    }

    public static BStatus make(BStatus orig, int bits) {
        if (orig.bits == bits) {
            return orig;
        }
        return BStatus.make(bits, orig.facets);
    }

    public static BStatus make(int bits, BFacets facets) {
        if ((facets == null || facets.isNull()) && bits < 256) {
            if (nullLookupTable[bits] == null) {
                BStatus.nullLookupTable[bits] = new BStatus(bits, BFacets.NULL);
            }
            return nullLookupTable[bits];
        }
        return (BStatus)new BStatus(bits, facets).intern();
    }

    public static BStatus make(BStatus orig, int bit, boolean bitState) {
        int newBits;
        int n = newBits = bitState ? orig.bits | bit : orig.bits & ~bit;
        if (newBits == 0 && orig.facets.isNull()) {
            return ok;
        }
        if (orig.bits == newBits) {
            return orig;
        }
        return BStatus.make(newBits, orig.facets);
    }

    public static BStatus makeDisabled(BStatus orig, boolean state) {
        return BStatus.make(orig, 1, state);
    }

    public static BStatus makeFault(BStatus orig, boolean state) {
        return BStatus.make(orig, 2, state);
    }

    public static BStatus makeDown(BStatus orig, boolean state) {
        return BStatus.make(orig, 4, state);
    }

    public static BStatus makeAlarm(BStatus orig, boolean state) {
        return BStatus.make(orig, 8, state);
    }

    public static BStatus makeStale(BStatus orig, boolean state) {
        return BStatus.make(orig, 16, state);
    }

    public static BStatus makeOverridden(BStatus orig, boolean state) {
        return BStatus.make(orig, 32, state);
    }

    public static BStatus makeNull(BStatus orig, boolean state) {
        return BStatus.make(orig, 64, state);
    }

    public static BStatus makeUnackedAlarm(BStatus orig, boolean state) {
        return BStatus.make(orig, 128, state);
    }

    public static BStatus make(BStatus orig, String name, BIDataValue value) {
        BFacets facets = BFacets.make(orig.facets, name, value);
        if (facets == orig.facets) {
            return orig;
        }
        return BStatus.make(orig.bits, facets);
    }

    public static BStatus make(BStatus orig, String name, boolean value) {
        return BStatus.make(orig, name, BBoolean.make(value));
    }

    public static BStatus make(BStatus orig, String name, int value) {
        return BStatus.make(orig, name, BInteger.make(value));
    }

    public static BStatus make(BStatus orig, String name, float value) {
        return BStatus.make(orig, name, BFloat.make(value));
    }

    public static BStatus make(BStatus orig, String name, String value) {
        return BStatus.make(orig, name, BString.make(value));
    }

    private BStatus(int bits, BFacets facets) {
        this.bits = bits;
        this.facets = facets != null ? facets : BFacets.NULL;
    }

    @Override
    public BStatus getStatus() {
        return this;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public BObject get(String name) {
        return this.facets.get(name);
    }

    public boolean getb(String name, boolean def) {
        return this.facets.getb(name, def);
    }

    public int geti(String name, int def) {
        return this.facets.geti(name, def);
    }

    public long getl(String name, long def) {
        return this.facets.getl(name, def);
    }

    public float getf(String name, float def) {
        return this.facets.getf(name, def);
    }

    public double getd(String name, double def) {
        return this.facets.getd(name, def);
    }

    public String gets(String name, String def) {
        return this.facets.gets(name, def);
    }

    public int getBits() {
        return this.bits;
    }

    public boolean isValid() {
        return (this.bits & 1) == 0 && (this.bits & 2) == 0 && (this.bits & 4) == 0 && (this.bits & 0x10) == 0 && (this.bits & 0x40) == 0;
    }

    public boolean isOk() {
        return this.bits == 0;
    }

    public boolean isDisabled() {
        return (this.bits & 1) != 0;
    }

    public boolean isFault() {
        return (this.bits & 2) != 0;
    }

    public boolean isDown() {
        return (this.bits & 4) != 0;
    }

    public boolean isAlarm() {
        return (this.bits & 8) != 0;
    }

    public boolean isStale() {
        return (this.bits & 0x10) != 0;
    }

    public boolean isOverridden() {
        return (this.bits & 0x20) != 0;
    }

    @Override
    public boolean isNull() {
        return (this.bits & 0x40) != 0;
    }

    public boolean isUnackedAlarm() {
        return (this.bits & 0x80) != 0;
    }

    @Override
    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    @Override
    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    @Override
    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    @Override
    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    @Override
    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    @Override
    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    @Override
    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BStatus.make(mask);
    }

    @Override
    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    @Override
    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    @Override
    public boolean isEmpty() {
        return this.bits == 0;
    }

    @Override
    public String getEmptyTag() {
        return "ok";
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.bits << 13 ^ this.facets.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BStatus) {
            BStatus x = (BStatus)obj;
            return x.bits == this.bits && x.facets.equals(this.facets);
        }
        return false;
    }

    public String flagsToString(Context cx) {
        if (this.bits == 0) {
            return Lexicon.make(Sys.getBajaModule(), cx).getText("Status.ok");
        }
        StringBuffer s = new StringBuffer();
        if (this.isDisabled()) {
            s.append(this.getDisplayTag(1, cx)).append(',');
        }
        if (this.isFault()) {
            s.append(this.getDisplayTag(2, cx)).append(',');
        }
        if (this.isDown()) {
            s.append(this.getDisplayTag(4, cx)).append(',');
        }
        if (this.isAlarm()) {
            s.append(this.getDisplayTag(8, cx)).append(',');
        }
        if (this.isStale()) {
            s.append(this.getDisplayTag(16, cx)).append(',');
        }
        if (this.isOverridden()) {
            s.append(this.getDisplayTag(32, cx)).append(',');
        }
        if (this.isNull()) {
            s.append(this.getDisplayTag(64, cx)).append(',');
        }
        if (this.isUnackedAlarm()) {
            s.append(this.getDisplayTag(128, cx)).append(',');
        }
        s.setLength(s.length() - 1);
        return s.toString();
    }

    @Override
    public String toString(Context context) {
        StringBuffer s = new StringBuffer();
        s.append('{').append(this.flagsToString(context)).append('}');
        if (!this.facets.isNull()) {
            String[] keys = this.facets.list();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                BObject val = this.facets.get(key);
                if (key.equals(ACTIVE_LEVEL)) {
                    s.append(" @ ").append(val);
                    continue;
                }
                if (val == BBoolean.TRUE) {
                    s.append(' ').append(key);
                    continue;
                }
                s.append(' ').append(key).append('=').append(val);
            }
        }
        return s.toString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
        out.writeUTF(this.facets.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BStatus.make(in.readInt(), (BFacets)BFacets.NULL.decodeFromString(in.readUTF()));
    }

    @Override
    public String encodeToString() throws IOException {
        String s = Integer.toHexString(this.bits);
        if (this.facets.isNull()) {
            return s;
        }
        return s + ';' + this.facets.encodeToString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            int semi = s.indexOf(59);
            if (semi < 0) {
                return BStatus.make(Integer.parseInt(s, 16));
            }
            int bits = Integer.parseInt(s.substring(0, semi), 16);
            BFacets facets = (BFacets)BFacets.NULL.decodeFromString(s.substring(semi + 1));
            return BStatus.make(bits, facets);
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public BSimple getForegroundColor(BSimple defaultColor) {
        if (this.isDisabled()) {
            return disabledFg;
        }
        if (this.isFault()) {
            return faultFg;
        }
        if (this.isDown()) {
            return downFg;
        }
        if (this.isAlarm()) {
            return alarmFg;
        }
        if (this.isStale()) {
            return staleFg;
        }
        if (this.isOverridden()) {
            return overriddenFg;
        }
        return defaultColor;
    }

    public BSimple getBackgroundColor(BSimple defaultColor) {
        if (this.isDisabled()) {
            return disabledBg;
        }
        if (this.isFault()) {
            return faultBg;
        }
        if (this.isDown()) {
            return downBg;
        }
        if (this.isAlarm()) {
            return alarmBg;
        }
        if (this.isStale()) {
            return staleBg;
        }
        if (this.isOverridden()) {
            return overriddenBg;
        }
        return defaultColor;
    }

    static BSimple color(Lexicon lex, BSimple proto, String key) throws IOException {
        String val = lex.get(key, null);
        if (val == null) {
            return null;
        }
        return (BSimple)proto.decodeFromString(val);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        try {
            Lexicon lex = Lexicon.make("baja");
            BSimple proto = (BSimple)Sys.getType("gx:Color").getInstance();
            disabledFg = BStatus.color(lex, proto, "Status.disabled.fg");
            disabledBg = BStatus.color(lex, proto, "Status.disabled.bg");
            faultFg = BStatus.color(lex, proto, "Status.fault.fg");
            faultBg = BStatus.color(lex, proto, "Status.fault.bg");
            downFg = BStatus.color(lex, proto, "Status.down.fg");
            downBg = BStatus.color(lex, proto, "Status.down.bg");
            alarmFg = BStatus.color(lex, proto, "Status.alarm.fg");
            alarmBg = BStatus.color(lex, proto, "Status.alarm.bg");
            staleFg = BStatus.color(lex, proto, "Status.stale.fg");
            staleBg = BStatus.color(lex, proto, "Status.stale.bg");
            overriddenFg = BStatus.color(lex, proto, "Status.overridden.fg");
            overriddenBg = BStatus.color(lex, proto, "Status.overridden.bg");
        }
        catch (TypeNotFoundException lex) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        nullLookupTable = new BStatus[256];
        ok = BStatus.make(0, BFacets.NULL);
        disabled = BStatus.make(1, BFacets.NULL);
        fault = BStatus.make(2, BFacets.NULL);
        down = BStatus.make(4, BFacets.NULL);
        alarm = BStatus.make(8, BFacets.NULL);
        stale = BStatus.make(16, BFacets.NULL);
        overridden = BStatus.make(32, BFacets.NULL);
        nullStatus = BStatus.make(64, BFacets.NULL);
        unackedAlarm = BStatus.make(128, BFacets.NULL);
        DEFAULT = ok;
        support = new BBitString.Support(DEFAULT);
        support.add(1, "disabled");
        support.add(2, "fault");
        support.add(4, "down");
        support.add(8, "alarm");
        support.add(16, "stale");
        support.add(32, "overridden");
        support.add(64, "null");
        support.add(128, "unackedAlarm");
        TYPE = Sys.loadType(BStatus.class);
    }
}

