/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.spy;

import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.file.FilePath;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.session.CsrfException;
import javax.baja.space.BSpace;
import javax.baja.spy.BSpy;
import javax.baja.spy.ISpyDir;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BSpySpace
extends BSpace
implements BICategorizable,
BIProtected {
    private static final BIcon icon = BIcon.std("spy.png");
    public static final BSpySpace INSTANCE = new BSpySpace();
    public static final Type TYPE;
    private static final BOrd ordInSession;

    protected BSpySpace() {
        super("spy", LexiconText.make("baja", "nav.spy"));
    }

    protected BSpySpace(String name, LexiconText lexText) {
        super(name, lexText);
    }

    public BSpy resolveSpy(FilePath path) throws SyntaxException, UnresolvedException {
        Spy spy = Spy.ROOT;
        String name = null;
        try {
            for (int i = 0; i < path.depth(); ++i) {
                name = path.nameAt(i);
                if ((spy = spy instanceof ISpyDir ? ((ISpyDir)((Object)spy)).find(name) : null) == null) break;
            }
            if (spy == null) {
                spy = new NotFoundSpy();
            }
        }
        catch (CsrfException e) {
            String retryName = null;
            if (spy instanceof ISpyDir) {
                retryName = "../" + name;
            }
            spy = new NotFoundSpy("Invalid or missing token", retryName);
        }
        return BSpy.make(path, spy);
    }

    @Override
    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(ordInSession);
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        return BCategoryService.getService().getAppliedCategoryMask(ordInSession);
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor(this);
        }
        return BPermissions.all;
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasAdminRead();
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        return false;
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    @Override
    public BOrd getOrdInSession() {
        return ordInSession;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        BLocalHost.INSTANCE.addNavChild(INSTANCE);
        BLocalHost.INSTANCE.mountSpace(INSTANCE);
        TYPE = Sys.loadType(BSpySpace.class);
        ordInSession = BOrd.make("spy:/");
    }

    static class NotFoundSpy
    extends Spy {
        String error;
        String retryHref;

        public NotFoundSpy() {
        }

        public NotFoundSpy(String error, String retryHref) {
            this.error = error;
            this.retryHref = retryHref;
        }

        @Override
        public String getTitle() {
            return "Spy Not Found";
        }

        @Override
        public void write(SpyWriter out) {
            String title = this.error != null ? "Spy Not Found: " + this.error : "Spy Not Found";
            out.w("<h1>" + title + "</h1>");
            out.w(out.path);
            if (this.retryHref != null) {
                out.w("<p>It is possible that you were directed to this page due to a malicious hyperlink. If you are sure you would like to proceed using a proper token, click here: ").mutatorButton(this.retryHref, "Retry").w("</p>");
            }
        }
    }
}

