/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.space;

import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavContainer;
import javax.baja.space.BSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSpaceScheme
extends BOrdScheme {
    public static final Type TYPE = Sys.loadType(BSpaceScheme.class);

    protected BSpaceScheme(String schemeId) {
        super(schemeId);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BSpace space;
        block3: {
            BISession session = this.toSession(base.get());
            space = (BSpace)session.getNavChild(this.getNavChildSpaceId());
            if (space == null) {
                try {
                    space = this.makeSpaceForSession(session);
                    ((BINavContainer)((Object)session)).addNavChild(space);
                }
                catch (RuntimeException e) {
                    space = (BSpace)session.getNavChild(this.getNavChildSpaceId());
                    if (space != null) break block3;
                    throw e;
                }
            }
        }
        return this.resolve(base, query, space);
    }

    public BISession toSession(BObject base) {
        BISession session = BOrd.toSession(base);
        if (session != null) {
            return session;
        }
        throw new InvalidOrdBaseException("" + base);
    }

    public BSpace makeSpaceForSession(BISession session) {
        Type spaceType = this.getSpaceType();
        try {
            AgentList agents = session.asObject().getAgents();
            agents = agents.filter(AgentFilter.is(spaceType));
            return (BSpace)agents.getDefault().getInstance();
        }
        catch (NoSuchAgentException e) {
            throw new InvalidOrdBaseException("Cannot find impl of " + spaceType + " for " + session.getType());
        }
    }

    protected String getNavChildSpaceId() {
        return this.getId();
    }

    public abstract Type getSpaceType();

    public abstract OrdTarget resolve(OrdTarget var1, OrdQuery var2, BSpace var3);

    @Override
    public Type getType() {
        return TYPE;
    }
}

