/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.space;

import javax.baja.agent.BIAgent;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.space.BISpace;
import javax.baja.space.BISpaceContainer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public abstract class BSpace
extends BNavContainer
implements BIAgent,
BISpace {
    public static final Type TYPE = Sys.loadType(BSpace.class);
    BISpaceContainer spaceParent = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BSpace(String name, LexiconText lexText) {
        super(name, lexText);
    }

    protected BSpace(String name) {
        super(name);
    }

    public String getSpaceId() {
        return this.getType().getTypeInfo().toString();
    }

    @Override
    public boolean isMounted() {
        return this.getHost() != null;
    }

    @Override
    public BISpaceContainer getSpaceContainer() {
        return this.spaceParent;
    }

    @Override
    public void setSpaceContainer(BISpaceContainer spaceParent) {
        this.spaceParent = spaceParent;
    }

    @Override
    public BHost getHost() {
        BINavNode p = this.getNavParent();
        if (p instanceof BHost) {
            return (BHost)p;
        }
        if (p instanceof BISession) {
            return ((BISession)p).getHost();
        }
        return null;
    }

    @Override
    public BISession getSession() {
        BINavNode p = this.getNavParent();
        if (p instanceof BISession) {
            return (BISession)p;
        }
        return null;
    }

    @Override
    public BOrd getAbsoluteOrd() {
        BHost host = this.getHost();
        if (host == null) {
            return null;
        }
        return BOrd.make(host.getAbsoluteOrd(), this.getOrdInHost());
    }

    @Override
    public BOrd getOrdInHost() {
        BISession session = this.getSession();
        if (session == null) {
            return null;
        }
        return BOrd.make(session.getOrdInHost(), this.getOrdInSession());
    }

    @Override
    public abstract BOrd getOrdInSession();

    @Override
    public BOrd getOrdInSpaceContainer() {
        return this.getOrdInHost();
    }

    @Override
    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("Space", 2);
        out.prop((Object)"isMounted", this.isMounted());
        out.prop((Object)"host", this.getHost());
        out.prop((Object)"session", this.getSession());
        out.prop((Object)"absoluteOrd", this.getAbsoluteOrd());
        out.prop((Object)"ordInHost", this.getOrdInHost());
        out.prop((Object)"ordInSession", this.getOrdInSession());
        out.prop((Object)"navOrd", this.getNavOrd());
        out.endProps();
        super.spy(out);
    }
}

