/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.space;

import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public interface BISpaceNode
extends BINavNode {
    public static final Type TYPE = Sys.loadType(BISpaceNode.class);

    default public BHost getHost() {
        BSpace space = this.getSpace();
        if (space != null) {
            return space.getHost();
        }
        return null;
    }

    default public BISession getSession() {
        BSpace space = this.getSpace();
        if (space != null) {
            return space.getSession();
        }
        return null;
    }

    public BSpace getSpace();

    default public boolean isMounted() {
        BSpace space = this.getSpace();
        if (space != null) {
            return space.isMounted();
        }
        return false;
    }

    default public BOrd getAbsoluteOrd() {
        if (this.isMounted()) {
            return BOrd.make(this.getSpace().getAbsoluteOrd(), this.getOrdInSpace());
        }
        return null;
    }

    default public BOrd getOrdInHost() {
        if (this.isMounted()) {
            return BOrd.make(this.getSpace().getOrdInHost(), this.getOrdInSpace());
        }
        return null;
    }

    public BOrd getOrdInSession();

    public BOrd getOrdInSpace();

    public boolean isPendingMove();

    public void setPendingMove(boolean var1);
}

