/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.dashboard;

import com.tridium.json.JSONObject;
import java.util.Objects;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.sys.Type;

public class SecurityDashboardItem {
    private final LexiconFormatInfo summary;
    private final LexiconFormatInfo description;
    private final BSecurityItemStatus status;

    public SecurityDashboardItem(LexiconFormatInfo summary, LexiconFormatInfo description, BSecurityItemStatus status) {
        this.summary = summary;
        this.description = description;
        this.status = status;
    }

    public static SecurityDashboardItem make(LexiconFormatInfo summaryInfo, LexiconFormatInfo descriptionInfo, BSecurityItemStatus status) {
        return new SecurityDashboardItem(summaryInfo, descriptionInfo, status);
    }

    public static SecurityDashboardItem make(Type type, String summaryKey, String descriptionKey, BSecurityItemStatus status) {
        return new SecurityDashboardItem(LexiconFormatInfo.make(type, summaryKey), LexiconFormatInfo.make(type, descriptionKey), status);
    }

    public static SecurityDashboardItem makeInfo(Type type, String summaryKey, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionKey, BSecurityItemStatus.securityStatusInfo);
    }

    public static SecurityDashboardItem makeOk(Type type, String summaryKey, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionKey, BSecurityItemStatus.securityStatusOK);
    }

    public static SecurityDashboardItem makeWarning(Type type, String summaryKey, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionKey, BSecurityItemStatus.securityStatusWarning);
    }

    public static SecurityDashboardItem makeAlert(Type type, String summaryKey, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionKey, BSecurityItemStatus.securityStatusAlert);
    }

    public static SecurityDashboardItem make(Type type, LexiconFormatInfo summaryInfo, String descriptionKey, BSecurityItemStatus status) {
        return new SecurityDashboardItem(summaryInfo, LexiconFormatInfo.make(type, descriptionKey), status);
    }

    public static SecurityDashboardItem makeInfo(Type type, LexiconFormatInfo summaryInfo, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryInfo, descriptionKey, BSecurityItemStatus.securityStatusInfo);
    }

    public static SecurityDashboardItem makeOk(Type type, LexiconFormatInfo summaryInfo, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryInfo, descriptionKey, BSecurityItemStatus.securityStatusOK);
    }

    public static SecurityDashboardItem makeWarning(Type type, LexiconFormatInfo summaryInfo, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryInfo, descriptionKey, BSecurityItemStatus.securityStatusWarning);
    }

    public static SecurityDashboardItem makeAlert(Type type, LexiconFormatInfo summaryInfo, String descriptionKey) {
        return SecurityDashboardItem.make(type, summaryInfo, descriptionKey, BSecurityItemStatus.securityStatusAlert);
    }

    public static SecurityDashboardItem make(Type type, String summaryKey, LexiconFormatInfo descriptionInfo, BSecurityItemStatus status) {
        return new SecurityDashboardItem(LexiconFormatInfo.make(type, summaryKey), descriptionInfo, status);
    }

    public static SecurityDashboardItem makeInfo(Type type, String summaryKey, LexiconFormatInfo descriptionInfo) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionInfo, BSecurityItemStatus.securityStatusInfo);
    }

    public static SecurityDashboardItem makeOk(Type type, String summaryKey, LexiconFormatInfo descriptionInfo) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionInfo, BSecurityItemStatus.securityStatusOK);
    }

    public static SecurityDashboardItem makeWarning(Type type, String summaryKey, LexiconFormatInfo descriptionInfo) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionInfo, BSecurityItemStatus.securityStatusWarning);
    }

    public static SecurityDashboardItem makeAlert(Type type, String summaryKey, LexiconFormatInfo descriptionInfo) {
        return SecurityDashboardItem.make(type, summaryKey, descriptionInfo, BSecurityItemStatus.securityStatusAlert);
    }

    public static SecurityDashboardItem makeInfo(LexiconFormatInfo summaryInfo, LexiconFormatInfo descriptionInfo) {
        return new SecurityDashboardItem(summaryInfo, descriptionInfo, BSecurityItemStatus.securityStatusInfo);
    }

    public static SecurityDashboardItem makeOk(LexiconFormatInfo summaryInfo, LexiconFormatInfo descriptionInfo) {
        return new SecurityDashboardItem(summaryInfo, descriptionInfo, BSecurityItemStatus.securityStatusOK);
    }

    public static SecurityDashboardItem makeWarning(LexiconFormatInfo summaryInfo, LexiconFormatInfo descriptionInfo) {
        return new SecurityDashboardItem(summaryInfo, descriptionInfo, BSecurityItemStatus.securityStatusWarning);
    }

    public static SecurityDashboardItem makeAlert(LexiconFormatInfo summaryInfo, LexiconFormatInfo descriptionInfo) {
        return new SecurityDashboardItem(summaryInfo, descriptionInfo, BSecurityItemStatus.securityStatusAlert);
    }

    public LexiconFormatInfo getSummary() {
        return this.summary;
    }

    public LexiconFormatInfo getDescription() {
        return this.description;
    }

    public BSecurityItemStatus getStatus() {
        return this.status;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("status", (Object)this.status.getTag());
        json.put("summary", (Object)this.summary.toJSON());
        json.put("description", (Object)this.description.toJSON());
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityDashboardItem that = (SecurityDashboardItem)o;
        return Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.summary, this.description, this.status);
    }

    public String toString() {
        return "SecurityDashboardItem {\n  summary=" + this.summary + ",\n  description=" + this.description + ",\n  status=" + this.status + "\n}";
    }
}

