/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.SupplierWithException;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.NiagaraBasicPermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.baja.security.BPassword;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

public final class PasswordEncodingContext
implements Context,
AutoCloseable {
    private final Context base;
    private boolean isClosed = false;
    private EncryptionKeySource decryptionKeySource = EncryptionKeySource.none;
    private EncryptionKeySource encryptionKeySource = EncryptionKeySource.none;
    private Optional<ISecretBytesSupplier> decryptionKey = Optional.empty();
    private Optional<ISecretBytesSupplier> encryptionKey = Optional.empty();
    private Optional<EncryptionAlgorithmBundle> algorithmBundle = Optional.empty();
    private SupplierWithException<BPassword, MissingEncodingKeyException> decodeFailureSupplier = EXCEPTION_DECODE_FAILURE_SUPPLIER;
    private SupplierWithException<String, MissingEncodingKeyException> encodeFailureSupplier = EXCEPTION_ENCODE_FAILURE_SUPPLIER;
    private static final NiagaraBasicPermission GET_CONTEXT_KEY_PERMISSION = new NiagaraBasicPermission("GET_CONTEXT_KEY");
    private static final NiagaraBasicPermission SET_CONTEXT_KEY_PERMISSION = new NiagaraBasicPermission("SET_CONTEXT_KEY");
    public static final SupplierWithException<BPassword, MissingEncodingKeyException> EXCEPTION_DECODE_FAILURE_SUPPLIER = () -> {
        throw new MissingEncodingKeyException();
    };
    public static final SupplierWithException<BPassword, MissingEncodingKeyException> DEFAULT_DECODE_FAILURE_SUPPLIER = () -> BPassword.DEFAULT;
    public static final SupplierWithException<String, MissingEncodingKeyException> EXCEPTION_ENCODE_FAILURE_SUPPLIER = () -> {
        throw new MissingEncodingKeyException();
    };
    public static final SupplierWithException<String, MissingEncodingKeyException> DEFAULT_ENCODE_FAILURE_SUPPLIER = () -> {
        try {
            return BPassword.DEFAULT.encodeToString();
        }
        catch (IOException wontHappenForDefault) {
            return null;
        }
    };

    public PasswordEncodingContext(Context base, EncryptionKeySource decryptionKeySource, EncryptionKeySource encryptionKeySource, Optional<ISecretBytesSupplier> decryptionKey, Optional<ISecretBytesSupplier> encryptionKey) {
        this(base);
        PasswordEncodingContext.validateKeyCombination("encryption", encryptionKeySource, encryptionKey);
        PasswordEncodingContext.validateKeyCombination("decryption", decryptionKeySource, decryptionKey);
        this.encryptionKeySource = encryptionKeySource;
        this.decryptionKeySource = decryptionKeySource;
        this.decryptionKey = decryptionKey;
        this.encryptionKey = encryptionKey;
    }

    public PasswordEncodingContext(Context base) {
        this.base = base == null ? new BasicContext() : base;
        this.decryptionKeySource = EncryptionKeySource.keyring;
        this.encryptionKeySource = EncryptionKeySource.keyring;
    }

    public static PasswordEncodingContext makeKeyring() {
        return new PasswordEncodingContext(null, EncryptionKeySource.keyring, EncryptionKeySource.keyring, Optional.empty(), Optional.empty());
    }

    public static PasswordEncodingContext makeNone() {
        return new PasswordEncodingContext(null, EncryptionKeySource.none, EncryptionKeySource.none, Optional.empty(), Optional.empty());
    }

    public static Context updateContext(Context from, Consumer<PasswordEncodingContext> consumer) {
        Objects.requireNonNull(consumer);
        for (Context toCheck = from; toCheck != null; toCheck = toCheck.getBase()) {
            if (!(toCheck instanceof PasswordEncodingContext)) continue;
            consumer.accept((PasswordEncodingContext)toCheck);
            return from;
        }
        PasswordEncodingContext result = new PasswordEncodingContext(from);
        consumer.accept(result);
        return result;
    }

    public static Context updateForKeyring(Context from) {
        return PasswordEncodingContext.updateContext(from, pContext -> pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.keyring, Optional.empty()));
    }

    public static Context updateForNone(Context from) {
        return AccessController.doPrivileged(() -> PasswordEncodingContext.updateContext(from, pContext -> pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.none, Optional.empty())));
    }

    public static Context updateForExternal(Context from, ISecretBytesSupplier keySupplier) {
        Objects.requireNonNull(keySupplier);
        return PasswordEncodingContext.updateContext(from, pContext -> pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.external, Optional.of(keySupplier)));
    }

    public static PasswordEncodingContext from(Context from) {
        for (Context toCheck = from; toCheck != null; toCheck = toCheck.getBase()) {
            if (!(toCheck instanceof PasswordEncodingContext)) continue;
            return (PasswordEncodingContext)toCheck;
        }
        return new PasswordEncodingContext(from);
    }

    public PasswordEncodingContext setEncryptionAndDecryptionKey(EncryptionKeySource source) {
        this.checkClosed();
        return this.setEncryptionAndDecryptionKey(source, Optional.empty());
    }

    public PasswordEncodingContext setEncryptionAndDecryptionKey(EncryptionKeySource source, Optional<ISecretBytesSupplier> key) {
        this.checkClosed();
        PasswordEncodingContext.validateKeyCombination("encryption/decryption", source, key);
        this.encryptionKeySource = source;
        this.encryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.decryptionKey.ifPresent(ISecretBytesSupplier::close);
        if (key.isPresent()) {
            this.encryptionKey = Optional.of(key.get().newCopy());
            this.decryptionKey = Optional.of(key.get().newCopy());
        } else {
            this.encryptionKey = key;
            this.decryptionKey = key;
        }
        this.decryptionKeySource = source;
        return this;
    }

    public Optional<ISecretBytesSupplier> getDecryptionKey() {
        this.checkClosed();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)GET_CONTEXT_KEY_PERMISSION);
        }
        return this.decryptionKey;
    }

    public boolean hasDecryptionKey() {
        this.checkClosed();
        return this.decryptionKey.isPresent();
    }

    public EncryptionKeySource getDecryptionKeySource() {
        this.checkClosed();
        return this.decryptionKeySource;
    }

    public PasswordEncodingContext setDecryptionKey(EncryptionKeySource source, Optional<ISecretBytesSupplier> key) {
        this.checkClosed();
        PasswordEncodingContext.validateKeyCombination("decryption", source, key);
        this.decryptionKeySource = source;
        this.decryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.decryptionKey = key.isPresent() ? Optional.of(key.get().newCopy()) : key;
        return this;
    }

    public PasswordEncodingContext setDecryptionUndefined() {
        this.checkClosed();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)SET_CONTEXT_KEY_PERMISSION);
        }
        this.decryptionKeySource = EncryptionKeySource.undefined;
        this.decryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.decryptionKey = Optional.empty();
        return this;
    }

    public Optional<ISecretBytesSupplier> getEncryptionKey() {
        this.checkClosed();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)GET_CONTEXT_KEY_PERMISSION);
        }
        return this.encryptionKey;
    }

    public boolean hasEncryptionKey() {
        this.checkClosed();
        return this.encryptionKey.isPresent();
    }

    public EncryptionKeySource getEncryptionKeySource() {
        this.checkClosed();
        return this.encryptionKeySource;
    }

    public PasswordEncodingContext setEncryptionKey(EncryptionKeySource source, Optional<ISecretBytesSupplier> key) {
        this.checkClosed();
        PasswordEncodingContext.validateKeyCombination("encryption", source, key);
        this.encryptionKeySource = source;
        this.encryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.encryptionKey = key.isPresent() ? Optional.of(key.get().newCopy()) : key;
        return this;
    }

    public PasswordEncodingContext setEncryptionUndefined() {
        this.checkClosed();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)SET_CONTEXT_KEY_PERMISSION);
        }
        this.encryptionKeySource = EncryptionKeySource.undefined;
        this.encryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.encryptionKey = Optional.empty();
        return this;
    }

    public PasswordEncodingContext setEncryptionAlgorithmBundle(EncryptionAlgorithmBundle algorithmBundle) {
        this.algorithmBundle = Optional.ofNullable(algorithmBundle);
        return this;
    }

    public Optional<EncryptionAlgorithmBundle> getEncryptionAlgorithmBundle() {
        return this.algorithmBundle;
    }

    public PasswordEncodingContext throwExceptionOnDecodeFailures() {
        return this.setDecodeFailureSupplier(EXCEPTION_DECODE_FAILURE_SUPPLIER);
    }

    public PasswordEncodingContext defaultOnDecodeFailures() {
        return this.setDecodeFailureSupplier(DEFAULT_DECODE_FAILURE_SUPPLIER);
    }

    public PasswordEncodingContext setDecodeFailureSupplier(SupplierWithException<BPassword, MissingEncodingKeyException> value) {
        Objects.requireNonNull(value);
        this.decodeFailureSupplier = value;
        return this;
    }

    public BPassword getDecodeErrorPasswordValue() throws MissingEncodingKeyException {
        return (BPassword)this.decodeFailureSupplier.get();
    }

    public PasswordEncodingContext defaultOnEncodeFailures() {
        return this.setEncodeFailureSupplier(DEFAULT_ENCODE_FAILURE_SUPPLIER);
    }

    public PasswordEncodingContext throwExceptionOnEncodeFailures() {
        return this.setEncodeFailureSupplier(EXCEPTION_ENCODE_FAILURE_SUPPLIER);
    }

    public PasswordEncodingContext setEncodeFailureSupplier(SupplierWithException<String, MissingEncodingKeyException> value) {
        Objects.requireNonNull(value);
        this.encodeFailureSupplier = value;
        return this;
    }

    public String getErrorEncodedValue() throws MissingEncodingKeyException {
        return (String)this.encodeFailureSupplier.get();
    }

    @Override
    public Context getBase() {
        return this.base;
    }

    @Override
    public BUser getUser() {
        return this.base.getUser();
    }

    @Override
    public BFacets getFacets() {
        return this.base.getFacets();
    }

    @Override
    public BObject getFacet(String name) {
        return this.base.getFacet(name);
    }

    @Override
    public String getLanguage() {
        return this.base.getLanguage();
    }

    @Override
    public void close() {
        this.decryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.encryptionKey.ifPresent(ISecretBytesSupplier::close);
        this.decryptionKey = Optional.empty();
        this.encryptionKey = Optional.empty();
        this.decryptionKeySource = EncryptionKeySource.none;
        this.encryptionKeySource = EncryptionKeySource.none;
        this.isClosed = true;
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot perform operation on a PasswordEncodingContext that has been closed");
        }
    }

    private static void validateKeyCombination(String kind, EncryptionKeySource source, Optional<ISecretBytesSupplier> key) {
        Objects.requireNonNull(kind);
        Objects.requireNonNull(source);
        Objects.requireNonNull(key);
        if (key.isPresent()) {
            switch (source) {
                case keyring: 
                case none: 
                case undefined: {
                    throw new IllegalStateException("Cannot set " + kind + " key for EncryptionKeySource of " + source.name());
                }
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)SET_CONTEXT_KEY_PERMISSION);
            }
        }
    }
}

