/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:ClientCredentials"})})
public class BUsernameAndPassword
extends BStruct
implements BIUserCredentials,
BIAgent,
BIDeferOwnership {
    public static final Property username = BUsernameAndPassword.newProperty(0, BString.DEFAULT, null);
    public static final Property password = BUsernameAndPassword.newProperty(0, BPassword.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BUsernameAndPassword.class);
    private boolean newUser = false;

    @Override
    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BUsernameAndPassword(String username, BPassword password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public BUsernameAndPassword(String username, String password) {
        this(username, BPassword.make(password, (Context)null));
    }

    public BUsernameAndPassword() {
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BString.make(this.getUsername()).encode(out);
        this.getPassword().encode(out, context);
        out.flush();
        return bout.toByteArray();
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BUsernameAndPassword x = (BUsernameAndPassword)this.newCopy();
        x.set(username, (BValue)BString.DEFAULT.decode(in));
        x.set(password, (BValue)BPassword.DEFAULT.decode(in, context));
        return x;
    }

    @Override
    public boolean equivalent(Object obj) {
        if (obj != null && obj.getClass() == this.getClass() && SecurityUtil.equals((String)((BUsernameAndPassword)obj).getUsername(), (String)this.getUsername())) {
            BPassword p = ((BUsernameAndPassword)obj).getPassword();
            return p.equals(this.getPassword()) || p.getPasswordEncoder().isReversible() && this.getPassword().getPasswordEncoder().isReversible() && p.validate(this.getPassword());
        }
        return false;
    }

    @Override
    public boolean isNewUser() {
        return this.newUser;
    }

    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }
}

