/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.Objects;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BReversiblePasswordEncoder
extends BAbstractPasswordEncoder {
    public static final Type TYPE = Sys.loadType(BReversiblePasswordEncoder.class);
    private Optional<byte[]> encryptionKey = Optional.empty();
    private boolean usesExternalEncryptionKey = false;
    private static final NiagaraBasicPermission SET_ENCODING_KEY_PERMISSION = new NiagaraBasicPermission("SET_ENCODING_KEY");

    @Override
    public Type getType() {
        return TYPE;
    }

    public static String getDefaultEncodingType() {
        return BReversiblePasswordEncoder.getDefaultEncodingType(true);
    }

    public static BReversiblePasswordEncoder makeDefaultInstance() throws Exception {
        return (BReversiblePasswordEncoder)BReversiblePasswordEncoder.makeDefaultInstance(true);
    }

    public abstract void encode(SecretBytes var1) throws Exception;

    public abstract SecretBytes getSecretBytes() throws Exception;

    public abstract boolean validate(SecretBytes var1) throws Exception;

    public abstract void transcode(String var1, Optional<ISecretBytesSupplier> var2) throws Exception;

    @Override
    public final boolean validate(SecretChars password) throws Exception {
        try (SecretBytes bytes = password.asSecretBytes(StandardCharsets.UTF_8, false);){
            boolean bl = this.validate(bytes);
            return bl;
        }
    }

    public final void setUsesExternalEncryptionKey(boolean value) {
        this.usesExternalEncryptionKey = value;
    }

    public final boolean usesExternalEncryptionKey() {
        return this.usesExternalEncryptionKey;
    }

    public final boolean validateExternalEncryptionKey(Optional<ISecretBytesSupplier> key) {
        if (key.isPresent()) {
            return this.usesExternalEncryptionKey() && this.getEncryptionKey().isPresent() && SecurityUtil.equals((byte[])this.getEncryptionKey().get(), (byte[])((SecretBytes)key.get().get()).get());
        }
        return !this.usesExternalEncryptionKey();
    }

    public final void setExternalEncryptionKey(SecretBytes value) {
        Objects.requireNonNull(value);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)SET_ENCODING_KEY_PERMISSION);
        }
        this.usesExternalEncryptionKey = true;
        this.encryptionKey = Optional.of(value.newCopy().get());
    }

    @Override
    public final boolean isReversible() {
        return true;
    }

    @Override
    public final void encode(SecretChars password) throws Exception {
        try (SecretBytes secretBytes = password.asSecretBytes(StandardCharsets.UTF_8, false);){
            this.encode(secretBytes);
        }
    }

    @Override
    public final SecretChars getSecretChars() throws Exception {
        return SecretChars.fromSecretBytes((SecretBytes)this.getSecretBytes(), (Charset)StandardCharsets.UTF_8, (boolean)true);
    }

    @Override
    public final String getValue() throws Exception {
        try (SecretBytes valueBytes = this.getSecretBytes();){
            String string = new String(valueBytes.get(), StandardCharsets.UTF_8);
            return string;
        }
    }

    final Optional<byte[]> getEncryptionKey() {
        return this.encryptionKey;
    }
}

