/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.SecretChars;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public final class BPlainPasswordEncoder
extends BAbstractPasswordEncoder
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BPlainPasswordEncoder.class);
    private SecretChars value = null;
    public static final String ENCODING_TYPE = "plain.1";

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encode(SecretChars password) {
        this.value = password.newCopy();
    }

    @Override
    public void parse(String key) throws IllegalArgumentException {
        this.value = SecretChars.fromString((String)key);
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public String getValue() {
        return new String(this.value.get());
    }

    @Override
    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    @Override
    public boolean validate(SecretChars password) {
        return SecurityUtil.equals((char[])password.get(), (char[])this.value.get());
    }

    @Override
    public String getEncodedValue() {
        return new String(this.value.get());
    }
}

