/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.util.PasswordUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BAbstractAes256PasswordEncoder;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BIPasswordValidator;
import javax.baja.security.BNullPasswordEncoder;
import javax.baja.security.BPlainPasswordEncoder;
import javax.baja.security.BReversiblePasswordEncoder;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BPassword
extends BSimple
implements BIComparable,
BIPasswordValidator,
BIUnlinkable {
    public static final BPassword DEFAULT = new BPassword(BNullPasswordEncoder.getEncodedDefaultPassword(), (Context)null);
    public static final Type TYPE = Sys.loadType(BPassword.class);
    private BAbstractPasswordEncoder encoder;

    public static BPassword make(String key) {
        return BPassword.make(key, (Context)null);
    }

    public static BPassword make(String key, Context context) {
        Objects.requireNonNull(key);
        return new BPassword(key, context);
    }

    public static BPassword make(char[] key) {
        Objects.requireNonNull(key);
        String skey = new String(key);
        return BPassword.make(skey, (Context)null);
    }

    public static BPassword make(String password, String encodingType) {
        Objects.requireNonNull(password);
        return new BPassword(password, encodingType);
    }

    public static BPassword make(char[] password, String encodingType) {
        Objects.requireNonNull(password);
        Objects.requireNonNull(encodingType);
        String spassword = new String(password);
        return BPassword.make(spassword, encodingType);
    }

    public static BPassword make(PBEValidator pbeValidator) {
        Objects.requireNonNull(pbeValidator);
        return BPassword.make(pbeValidator.getEncodedValidator(), (Context)null);
    }

    public static BPassword make(BAbstractPasswordEncoder encoder) {
        return new BPassword(encoder);
    }

    private BPassword(String key, Context context) {
        String encodingType;
        PasswordEncodingContext pContext = PasswordEncodingContext.from(context);
        boolean encoded = true;
        try {
            encodingType = CryptographicAlgorithmBundle.extractName((String)key);
        }
        catch (IllegalArgumentException iae) {
            encodingType = null;
        }
        if (encodingType == null) {
            if (pContext.getDecryptionKeySource() == EncryptionKeySource.none && pContext.getEncryptionKeySource() == EncryptionKeySource.none) {
                this.handleConstructorMissingDecodingKey(pContext);
                return;
            }
            encoded = false;
            encodingType = BReversiblePasswordEncoder.getDefaultEncodingType();
        }
        try {
            this.encoder = BAbstractPasswordEncoder.make(encodingType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unrecognized encoding type: " + encodingType);
        }
        if (this.encoder instanceof BReversiblePasswordEncoder) {
            BReversiblePasswordEncoder reversiblePasswordEncoder = (BReversiblePasswordEncoder)this.encoder;
            if (pContext.getEncryptionKeySource() == EncryptionKeySource.none) {
                this.handleConstructorMissingDecodingKey(pContext);
            } else {
                if (pContext.getEncryptionKeySource() == EncryptionKeySource.undefined) {
                    try {
                        AccessController.doPrivileged(() -> {
                            if (pContext.getDecryptionKeySource() == EncryptionKeySource.keyring) {
                                reversiblePasswordEncoder.setUsesExternalEncryptionKey(false);
                            } else {
                                reversiblePasswordEncoder.setUsesExternalEncryptionKey(true);
                                if (pContext.getDecryptionKey().isPresent()) {
                                    reversiblePasswordEncoder.setExternalEncryptionKey((SecretBytes)pContext.getDecryptionKey().get().get());
                                }
                            }
                            this.encoder.parse(key);
                            return null;
                        });
                    }
                    catch (Exception e) {
                        throw new SecurityException();
                    }
                }
                if (pContext.getEncryptionKeySource() == EncryptionKeySource.keyring) {
                    reversiblePasswordEncoder.setUsesExternalEncryptionKey(false);
                } else if (pContext.getEncryptionKeySource() == EncryptionKeySource.external || pContext.getEncryptionKeySource() == EncryptionKeySource.shared) {
                    reversiblePasswordEncoder.setUsesExternalEncryptionKey(true);
                    if (pContext.getEncryptionKey().isPresent()) {
                        try {
                            AccessController.doPrivileged(() -> {
                                reversiblePasswordEncoder.setExternalEncryptionKey((SecretBytes)pContext.getEncryptionKey().get().get());
                                return null;
                            });
                        }
                        catch (Exception e) {
                            throw new SecurityException();
                        }
                    }
                }
                if (pContext.getDecryptionKeySource() == EncryptionKeySource.shared && pContext.getEncryptionKeySource() == EncryptionKeySource.shared && reversiblePasswordEncoder.validateExternalEncryptionKey(pContext.getDecryptionKey())) {
                    throw new IllegalArgumentException("Cannot re-use shared key");
                }
                if (pContext.getDecryptionKeySource() == EncryptionKeySource.none || !encoded) {
                    try {
                        if (encoded) {
                            reversiblePasswordEncoder.parse(key);
                        }
                        reversiblePasswordEncoder.encode(key);
                    }
                    catch (MissingEncodingKeyException rethrow) {
                        this.handleConstructorMissingEncodingKey(pContext);
                    }
                    catch (Exception e) {
                        throw new SecurityException();
                    }
                } else {
                    try {
                        AccessController.doPrivileged(() -> {
                            reversiblePasswordEncoder.transcode(key, pContext.getDecryptionKey());
                            return null;
                        });
                    }
                    catch (MissingEncodingKeyException rethrow) {
                        this.handleConstructorMissingEncodingKey(pContext);
                    }
                    catch (Exception e) {
                        throw new SecurityException();
                    }
                }
            }
        } else {
            try {
                if (encoded) {
                    this.encoder.parse(key);
                } else {
                    this.encoder.encode(key);
                }
            }
            catch (MissingEncodingKeyException meke) {
                this.handleConstructorMissingEncodingKey(pContext);
            }
            catch (Exception e) {
                throw new SecurityException();
            }
        }
    }

    private void handleConstructorMissingDecodingKey(PasswordEncodingContext pContext) {
        BPassword fallback = pContext.getDecodeErrorPasswordValue();
        this.encoder = (BAbstractPasswordEncoder)fallback.getPasswordEncoder().getType().getInstance();
        try {
            this.encoder.parse(fallback.getPasswordEncoder().getEncodedValue());
        }
        catch (SecurityException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    private void handleConstructorMissingEncodingKey(PasswordEncodingContext pContext) {
        BPassword fallback = BPassword.make(pContext.getErrorEncodedValue());
        this.encoder = (BAbstractPasswordEncoder)fallback.getPasswordEncoder().getType().getInstance();
        try {
            this.encoder.parse(fallback.getPasswordEncoder().getEncodedValue());
        }
        catch (SecurityException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    private BPassword(String password, String encodingType) {
        try {
            this.encoder = BAbstractPasswordEncoder.make(encodingType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unrecognized encoding type: " + encodingType);
        }
        try {
            this.encoder.encode(password);
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    private BPassword(BAbstractPasswordEncoder encoder) {
        this.encoder = encoder;
    }

    public String getValue() throws SecurityException {
        try {
            if (this.encoder.isReversible() || this.encoder instanceof BNullPasswordEncoder) {
                return this.encoder.getValue();
            }
            byte[] val = new byte[16];
            new SecureRandom().nextBytes(val);
            return Base64.getEncoder().encodeToString(val);
        }
        catch (AccessControlException | MissingEncodingKeyException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    public SecretChars getSecretChars() throws SecurityException {
        try {
            if (this.encoder.isReversible() || this.encoder instanceof BNullPasswordEncoder) {
                return this.encoder.getSecretChars();
            }
            byte[] val = new byte[16];
            new SecureRandom().nextBytes(val);
            return SecretChars.fromString((String)ByteArrayUtil.toHexString((byte[])val));
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    @Override
    public int hashCode() {
        return this.encoder.getEncodedValue().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BPassword && SecurityUtil.equals((String)this.encoder.getEncodedValue(), (String)((BPassword)obj).encoder.getEncodedValue());
    }

    @Override
    public int compareTo(Object obj) {
        return 0;
    }

    public boolean validate(BPassword toValidate) {
        if (toValidate != null && toValidate.getPasswordEncoder().isReversible()) {
            return AccessController.doPrivileged(() -> {
                try (SecretChars secretChars = toValidate.getSecretChars();){
                    Boolean bl = this.validate(secretChars);
                    return bl;
                }
            });
        }
        return false;
    }

    @Override
    public boolean validate(SecretChars password) {
        try {
            return this.encoder.validate(password);
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(SecretBytes secretData) {
        try {
            if (this.encoder instanceof BReversiblePasswordEncoder) {
                return ((BReversiblePasswordEncoder)this.encoder).validate(secretData);
            }
            try (SecretChars chars = SecretChars.fromSecretBytes((SecretBytes)secretData, (Charset)StandardCharsets.UTF_8, (boolean)false);){
                boolean bl = this.encoder.validate(chars);
                return bl;
            }
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    @Override
    public String toString(Context context) {
        return "--password--";
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        this.encode(out, null);
    }

    @Override
    public void encode(DataOutput out, Context context) throws IOException {
        out.writeUTF(this.encodeToString(context));
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decode(in, null);
    }

    @Override
    public BObject decode(DataInput in, Context context) throws IOException {
        String s = in.readUTF();
        if (s.equals("")) {
            return DEFAULT;
        }
        return this.decodeFromString(s, context);
    }

    @Override
    public String encodeToString() throws IOException {
        return this.encodeToString(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String encodeToString(Context context) throws IOException {
        BObject skipFacet;
        if (context != null && this != PasswordUtil.SUBSTITUTE_PASSWORD && BBoolean.TRUE == (skipFacet = context.getFacet("skipEncodingSensitive")) && this.getPasswordEncoder().isReversible()) {
            return PasswordUtil.SUBSTITUTE_PASSWORD.encodeToString(context);
        }
        PasswordEncodingContext pContext = PasswordEncodingContext.from(context);
        if (this.encoder instanceof BReversiblePasswordEncoder) {
            BReversiblePasswordEncoder reversibleEncoder = (BReversiblePasswordEncoder)this.encoder;
            if (EncryptionKeySource.keyring.equals((Object)pContext.getEncryptionKeySource())) {
                if (!reversibleEncoder.usesExternalEncryptionKey()) return this.encoder.getEncodedValue();
                try {
                    BReversiblePasswordEncoder transcoder = this.makeTranscoder(pContext);
                    try (SecretChars chars = this.encoder.getSecretChars();){
                        ((BAbstractPasswordEncoder)transcoder).encode(chars);
                        return transcoder.getEncodedValue();
                    }
                }
                catch (MissingEncodingKeyException meke) {
                    return pContext.getErrorEncodedValue();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            if (EncryptionKeySource.none.equals((Object)pContext.getEncryptionKeySource())) {
                if (!PasswordUtil.SUBSTITUTE_PASSWORD.validate(this)) return pContext.getErrorEncodedValue();
                return DEFAULT.encodeToString(context);
            }
            if (reversibleEncoder.usesExternalEncryptionKey()) {
                if (!pContext.hasEncryptionKey()) return this.encoder.getEncodedValue();
                try {
                    return AccessController.doPrivileged(() -> {
                        BReversiblePasswordEncoder transcoder = this.makeTranscoder(pContext);
                        transcoder.setExternalEncryptionKey((SecretBytes)pContext.getEncryptionKey().get().get());
                        Optional<byte[]> encryptionKey = ((BReversiblePasswordEncoder)this.encoder).getEncryptionKey();
                        if (!encryptionKey.isPresent()) {
                            throw new MissingEncodingKeyException();
                        }
                        try (SecretBytes bytes = new SecretBytes(((BReversiblePasswordEncoder)this.encoder).getEncryptionKey().get(), false);){
                            ISecretBytesSupplier key = ISecretBytesSupplier.wrap((SecretBytes)bytes);
                            transcoder.transcode(this.encoder.getEncodedValue(), Optional.of(key));
                            String string = transcoder.getEncodedValue();
                            return string;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    if (!(pae.getCause() instanceof IOException)) throw new IOException(pae.getCause());
                    throw (IOException)pae.getCause();
                }
            }
            if (!pContext.hasEncryptionKey()) {
                return pContext.getErrorEncodedValue();
            }
            try {
                return AccessController.doPrivileged(() -> {
                    BReversiblePasswordEncoder transcoder = this.makeTranscoder(pContext);
                    transcoder.setExternalEncryptionKey((SecretBytes)pContext.getEncryptionKey().get().get());
                    transcoder.transcode(this.encoder.getEncodedValue(), Optional.empty());
                    return transcoder.getEncodedValue();
                });
            }
            catch (PrivilegedActionException pae) {
                if (!(pae.getCause() instanceof IOException)) throw new IOException(pae.getCause());
                throw (IOException)pae.getCause();
            }
        }
        if (!(this.encoder instanceof BPlainPasswordEncoder)) return this.encoder.getEncodedValue();
        if (EncryptionKeySource.keyring.equals((Object)pContext.getEncryptionKeySource())) {
            try {
                BAbstractPasswordEncoder transcoder = BAbstractPasswordEncoder.makeDefaultInstance(false);
                try (SecretChars chars = this.encoder.getSecretChars();){
                    transcoder.encode(chars);
                    return transcoder.getEncodedValue();
                }
            }
            catch (MissingEncodingKeyException meke) {
                return pContext.getErrorEncodedValue();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (EncryptionKeySource.external.equals((Object)pContext.getEncryptionKeySource())) {
            if (!pContext.hasEncryptionKey()) {
                return pContext.getErrorEncodedValue();
            }
            try {
                return AccessController.doPrivileged(() -> {
                    BReversiblePasswordEncoder transcoder = BReversiblePasswordEncoder.makeDefaultInstance();
                    transcoder.setExternalEncryptionKey((SecretBytes)pContext.getEncryptionKey().get().get());
                    transcoder.transcode(this.encoder.getEncodedValue(), Optional.empty());
                    return transcoder.getEncodedValue();
                });
            }
            catch (PrivilegedActionException pae) {
                if (!(pae.getCause() instanceof IOException)) throw new IOException(pae.getCause());
                throw (IOException)pae.getCause();
            }
        }
        if (!EncryptionKeySource.none.equals((Object)pContext.getEncryptionKeySource())) return this.encoder.getEncodedValue();
        return pContext.getErrorEncodedValue();
    }

    private BReversiblePasswordEncoder makeTranscoder(PasswordEncodingContext context) throws Exception {
        Optional<EncryptionAlgorithmBundle> bundle = context.getEncryptionAlgorithmBundle();
        if (bundle.isPresent() && bundle.get() instanceof AesAlgorithmBundle && this.encoder instanceof BAbstractAes256PasswordEncoder) {
            String encodingType = ((BAbstractAes256PasswordEncoder)this.encoder).getAlgorithmBundle().getAlgorithmType() + '.' + bundle.get().getAlgorithmVersion();
            ((BAbstractAes256PasswordEncoder)this.encoder).getAlgorithmBundle().getAlgorithmType();
            return (BReversiblePasswordEncoder)BAbstractPasswordEncoder.make(encodingType);
        }
        return (BReversiblePasswordEncoder)BAbstractPasswordEncoder.make(this.encoder.getEncodingType());
    }

    @Override
    public BObject decodeFromString(String s, Context context) throws IOException {
        if (s.equals("")) {
            return DEFAULT;
        }
        return BPassword.make(s, context);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return this.decodeFromString(s, null);
    }

    public String getEncodingType() {
        return this.encoder.getEncodingType();
    }

    public BAbstractPasswordEncoder getPasswordEncoder() {
        return this.encoder;
    }

    public boolean isDefault() {
        return this.getPasswordEncoder() instanceof BNullPasswordEncoder;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

