/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:ClientCredentials"})})
public class BHttpFoxCredentials
extends BStruct
implements BIUserCredentials,
BIAgent {
    public static final Property username = BHttpFoxCredentials.newProperty(0, BString.DEFAULT, null);
    public static final Property sessionId = BHttpFoxCredentials.newProperty(0, BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BHttpFoxCredentials.class);

    @Override
    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    public String getSessionId() {
        return this.getString(sessionId);
    }

    public void setSessionId(String v) {
        this.setString(sessionId, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHttpFoxCredentials() {
    }

    public BHttpFoxCredentials(String username, String sessionId) {
        this.setUsername(username);
        this.setSessionId(sessionId);
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BHttpFoxCredentials x = (BHttpFoxCredentials)this.newCopy();
        x.set(username, (BValue)BString.DEFAULT.decode(in));
        x.set(sessionId, (BValue)BString.DEFAULT.decode(in));
        return x;
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BString.make(this.getUsername()).encode(out);
        BString.make(this.getSessionId()).encode(out);
        out.flush();
        return bout.toByteArray();
    }

    @Override
    public boolean equivalent(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && SecurityUtil.equals((String)((BHttpFoxCredentials)obj).getUsername(), (String)this.getUsername()) && SecurityUtil.equals((String)((BHttpFoxCredentials)obj).getSessionId(), (String)this.getSessionId());
    }
}

