/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.security.BIPreconnectCredentials;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:ClientCredentials"})})
@NiagaraProperties(value={@NiagaraProperty(name="certificateAlias", type="BString", flags=1, defaultValue="BString.DEFAULT"), @NiagaraProperty(name="username", type="BString", flags=1, defaultValue="BString.DEFAULT")})
public class BCertificateAliasCredential
extends BStruct
implements BIPreconnectCredentials,
BIAgent {
    public static final Property certificateAlias = BCertificateAliasCredential.newProperty(1, BString.DEFAULT, null);
    public static final Property username = BCertificateAliasCredential.newProperty(1, BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BCertificateAliasCredential.class);

    public String getCertificateAlias() {
        return this.getString(certificateAlias);
    }

    public void setCertificateAlias(String v) {
        this.setString(certificateAlias, v, null);
    }

    @Override
    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BString.make(this.getUsername()).encode(out);
        BString.make(this.getCertificateAlias()).encode(out);
        out.flush();
        return bout.toByteArray();
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BCertificateAliasCredential x = new BCertificateAliasCredential();
        x.set(username, (BValue)BString.DEFAULT.decode(in));
        x.set(certificateAlias, (BValue)BString.DEFAULT.decode(in));
        return x;
    }
}

