/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.AliasedAesAlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.KeyRingPermission;
import java.security.Permission;
import java.util.Objects;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAes256PasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public class BAliasedAes256PasswordEncoder
extends BAbstractAes256PasswordEncoder {
    public static final Type TYPE = Sys.loadType(BAliasedAes256PasswordEncoder.class);
    private String alternateOwner;
    public static final AliasedAesAlgorithmBundle ALGORITHM_BUNDLE = AliasedAesAlgorithmBundle.make((int)256);
    public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();
    public static final Version MIN_VERSION = new Version("4.6.0");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAliasedAes256PasswordEncoder() {
        this.keyAlias = "javax.baja.security.BAes256PasswordEncoder.key";
    }

    public BAliasedAes256PasswordEncoder(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    @Override
    public void parse(String key) throws Exception {
        try {
            String[] data = this.getAlgorithmBundle().decode(key);
            Objects.requireNonNull(data);
            this.keyAlias = data[0];
            this.iv = data[1];
            this.cipher = data[2];
        }
        catch (IllegalArgumentException iae) {
            this.encode(key);
        }
    }

    @Override
    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    @Override
    public String getEncodedValue() {
        String[] data = new String[this.getAlgorithmBundle().getDataElementCount()];
        data[0] = this.keyAlias;
        data[2] = this.cipher;
        data[1] = this.iv;
        return this.getAlgorithmBundle().encode(data);
    }

    @Override
    protected EncryptionAlgorithmBundle getAlgorithmBundle() {
        return ALGORITHM_BUNDLE;
    }

    public void setAlternateOwner(String alternateOwner) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new KeyRingPermission(this.keyAlias));
        }
        this.alternateOwner = alternateOwner;
    }

    @Override
    public String getAlternateOwner() {
        return this.alternateOwner;
    }
}

