/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

public class AuditEvent {
    public static final String CHANGED = "Changed";
    public static final String ADDED = "Added";
    public static final String REMOVED = "Removed";
    public static final String RENAMED = "Renamed";
    public static final String REORDERED = "Reordered";
    public static final String FLAGS_CHANGED = "Flags Changed";
    public static final String FACETS_CHANGED = "Facets Changed";
    public static final String RECATEGORIZED = "Recategorized";
    public static final String INVOKED = "Invoked";
    public static final String LOGIN = "Login";
    public static final String LOGOUT = "Logout";
    public static final String LOGIN_FAILURE = "Login Failure";
    public static final String TIMEOUT = "Logout (Timeout)";
    private DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy");
    private String operation;
    private String target;
    private String slotName;
    private String oldValue;
    private String value;
    private String userName;
    private BAbsTime timestamp;

    public AuditEvent(String operation, String target, String slotName, String oldValue, String value, String userName) {
        this.operation = operation;
        this.target = target;
        this.slotName = slotName;
        this.oldValue = oldValue;
        this.value = value;
        this.userName = userName;
        this.timestamp = Clock.time();
    }

    public String getOperation() {
        return this.operation;
    }

    public String getTarget() {
        return this.target;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getUserName() {
        return this.userName;
    }

    public BAbsTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[').append(this.format.format(new Date(this.timestamp.getMillis()))).append("][").append(this.userName).append("][").append(this.target).append("] ").append(this.toSummaryString());
        return s.toString();
    }

    public String toSummaryString() {
        StringBuffer s = new StringBuffer();
        if (this.operation.equals(CHANGED)) {
            s.append(this.slotName).append(": ").append(this.oldValue).append(" -> ").append(this.value);
        } else if (this.operation.equals(ADDED)) {
            s.append(this.slotName).append(": added");
        } else if (this.operation.equals(REMOVED)) {
            s.append(this.slotName).append(": removed");
        } else if (this.operation.equals(RENAMED)) {
            s.append(this.slotName).append(": renamed " + this.value);
        } else if (this.operation.equals(REORDERED)) {
            s.append("reordered");
        } else if (this.operation.equals(FLAGS_CHANGED)) {
            s.append(this.slotName).append(": flags ").append(this.oldValue).append(" -> ").append(this.value);
        } else if (this.operation.equals(RECATEGORIZED)) {
            s.append("recategorized ").append(this.oldValue).append(" -> ").append(this.value);
        } else if (this.operation.equals(INVOKED)) {
            s.append(this.slotName).append('(');
            if (this.value != null) {
                s.append(this.value);
            }
            s.append(')');
        } else if (this.operation.equals(LOGIN)) {
            s.append("login");
        } else if (this.operation.equals(LOGOUT)) {
            s.append("logout");
        } else if (this.operation.equals(LOGIN_FAILURE)) {
            s.append("login failure ").append(this.value);
        } else if (this.operation.equals(TIMEOUT)) {
            s.append("browser timeout");
        } else {
            s.append(this.operation);
            if (this.slotName != null) {
                s.append(";slotName=" + this.slotName);
            }
            if (this.oldValue != null) {
                s.append(";oldValue=" + this.oldValue);
            }
            if (this.value != null) {
                s.append(";value=" + this.value);
            }
        }
        return s.toString();
    }
}

