/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;

public final class AccessSlotCursor
implements SlotCursor<Slot> {
    SlotCursor<? extends Slot> c;
    Context context;

    public static AccessSlotCursor make(SlotCursor<? extends Slot> c, Context context) {
        return new AccessSlotCursor(c, context);
    }

    private AccessSlotCursor(SlotCursor<? extends Slot> c, Context context) {
        this.c = c;
        this.context = context;
    }

    @Override
    public void close() {
        this.c.close();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public boolean next() {
        while (this.c.next()) {
            if (!this.has()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextObject() {
        while (this.c.nextObject()) {
            if (!this.has()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextComponent() {
        while (this.c.nextComponent()) {
            if (!this.has()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean next(Class<?> cls) {
        while (this.c.next(cls)) {
            if (!this.has()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final BObject target() {
        return this.c.target();
    }

    @Override
    public final Slot slot() {
        return this.c.slot();
    }

    @Override
    public final Property property() {
        return this.c.property();
    }

    @Override
    public final int getTypeAccess() {
        return this.c.getTypeAccess();
    }

    @Override
    public BValue get() {
        return this.c.get();
    }

    @Override
    public final boolean getBoolean() {
        return this.c.getBoolean();
    }

    @Override
    public final int getInt() {
        return this.c.getInt();
    }

    @Override
    public final long getLong() {
        return this.c.getLong();
    }

    @Override
    public final float getFloat() {
        return this.c.getFloat();
    }

    @Override
    public final double getDouble() {
        return this.c.getDouble();
    }

    @Override
    public final String getString() {
        return this.c.getString();
    }

    @Override
    public final Action action() {
        return this.c.action();
    }

    @Override
    public final Topic topic() {
        return this.c.topic();
    }

    private boolean has() {
        boolean op;
        Slot slot;
        BComplex target = (BComplex)this.c.target();
        int flags = target.getFlags(slot = this.c.slot());
        if ((flags & 4) != 0) {
            return false;
        }
        if (this.context == null) {
            return true;
        }
        if (slot.isProperty() && this.c.getTypeAccess() == 7 && this.c.get() instanceof BComponent) {
            BComponent component = this.c.get().as(BComponent.class);
            return this.permissionsFor(component).has(BPermissions.operatorRead);
        }
        BComponent component = target.isComponent() ? target.asComponent() : target.asComplex().getParentComponent();
        BPermissions p = this.permissionsFor(component);
        boolean bl = op = (flags & 0x100) != 0;
        if (slot.isAction()) {
            if (op) {
                return p.has(4);
            }
            return p.has(64);
        }
        if (op) {
            return p.has(1);
        }
        return p.has(16);
    }

    private BPermissions permissionsFor(BComponent component) {
        if (component == null || this.context == null) {
            return BPermissions.all;
        }
        return component.getPermissions(this.context);
    }
}

