/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.role;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.role.BAbstractRole;
import javax.baja.role.BAdminRole;
import javax.baja.role.BIRole;
import javax.baja.role.BIRoleListener;
import javax.baja.role.BIRoleService;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BIRestrictedComponent;

public class BRoleService
extends BComponent
implements BIService,
BIRoleService,
BIRestrictedComponent {
    public static final Property admin = BRoleService.newProperty(0, new BAdminRole(), null);
    public static final Type TYPE = Sys.loadType(BRoleService.class);
    private static Type[] serviceTypes = new Type[]{TYPE, BIRoleService.TYPE};
    private static final BIcon icon = BIcon.std("navOnly/roleService.png");
    private Map<String, BIRole> superUsers = null;
    private Object SUPERUSER_LOCK = new Object();
    public static final String ADMIN_ROLE = "admin";
    private static final String DEFAULT_ROLE_SERVICE_NAMESPACE = "";
    static final Logger log = Logger.getLogger("sys.service");

    public BAbstractRole getAdmin() {
        return (BAbstractRole)this.get(admin);
    }

    public void setAdmin(BAbstractRole v) {
        this.set(admin, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BRoleService getService() {
        return (BRoleService)Sys.getService(TYPE);
    }

    @Override
    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    @Override
    public void serviceStarted() throws Exception {
    }

    @Override
    public void serviceStopped() throws Exception {
    }

    @Override
    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser(this, cx);
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    @Override
    public void checkRemove(Property property, Context context) {
        BValue value;
        String roleId = property.getName();
        BUser user = context != null ? context.getUser() : null;
        Map<String, BIRole> su = this.getSuperuserRoles();
        BIRole suRoleToRemove = su.get(roleId);
        if (suRoleToRemove != null) {
            this.checkRemoveSuperuserRole(su, user, suRoleToRemove);
        }
        if (user != null && (value = this.get(property)) instanceof BIRole && user != null) {
            this.checkRemoveRoleManagement(user, (BIRole)((Object)value));
        }
    }

    private void checkRemoveSuperuserRole(Map<String, BIRole> superUsers, BUser user, BIRole suRole) {
        Set<BIRole> userRoles;
        if (superUsers.size() <= 1) {
            throw new LocalizableRuntimeException("baja", "role.removal.cannotRemoveOnlySuperUserRole", new String[]{suRole.getRoleIdentifier()});
        }
        if (user != null && (userRoles = user.getRoleSet()).contains(suRole)) {
            userRoles.remove(suRole);
            boolean hasOtherSuperRole = false;
            for (BIRole role : userRoles) {
                if (!role.getPermissions().isSuperUser()) continue;
                hasOtherSuperRole = true;
                break;
            }
            if (!hasOtherSuperRole) {
                throw new LocalizableRuntimeException("baja", "role.removal.cannotRemoveYourOnlySuperUserRole", new String[]{suRole.getRoleIdentifier()});
            }
        }
    }

    private void checkRemoveRoleManagement(BUser user, BIRole role) {
        BUser userWithoutRole = (BUser)user.newCopy();
        userWithoutRole.removeRole(this, role.getRoleIdentifier(), Context.skipValidate);
        BPermissions permissions = this.getPermissions(userWithoutRole);
        if (!permissions.has(32)) {
            throw new LocalizableRuntimeException("baja", "role.removal.cannotRemoveYourOnlyRoleManagementRole", new String[]{role.getRoleIdentifier()});
        }
    }

    @Override
    public void added(Property property, Context context) {
        if (this.get(property) instanceof BIRole) {
            this.clearPermissionsCache();
        }
    }

    @Override
    public void removed(Property property, BValue oldValue, Context context) {
        if (!(oldValue instanceof BIRole)) {
            return;
        }
        this.clearPermissionsCache();
        for (BIRoleListener rl : this.getRoleListeners()) {
            try {
                rl.removeRole(this, property.getName());
            }
            catch (Exception e) {
                BRoleService.notificationError(rl, e);
            }
        }
    }

    @Override
    public void checkRename(Property property, String newName, Context context) {
        if (newName.equalsIgnoreCase(ADMIN_ROLE)) {
            throw new IllegalNameException("baja", "role.renameToAdmin", null);
        }
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (name.equalsIgnoreCase(ADMIN_ROLE)) {
            throw new IllegalNameException("baja", "role.renameToAdmin", null);
        }
    }

    @Override
    public void renamed(Property property, String oldName, Context context) {
        if (!(this.get(property) instanceof BIRole)) {
            return;
        }
        this.clearPermissionsCache();
        for (BIRoleListener rl : this.getRoleListeners()) {
            try {
                rl.renameRole(this, oldName, property.getName());
            }
            catch (Exception e) {
                BRoleService.notificationError(rl, e);
            }
        }
    }

    @Override
    public void changed(Property property, Context context) {
        if (this.get(property) instanceof BIRole) {
            this.changedRole((BIRole)((Object)this.get(property)), context);
        }
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        int wbRoleManager = list.indexOf("wbutil:RoleManager");
        int html5RoleManager = list.indexOf("webEditors:RoleManager");
        if (html5RoleManager >= 0 && html5RoleManager < wbRoleManager) {
            list.swap(wbRoleManager, html5RoleManager);
        }
        return list;
    }

    public void changedRole(BIRole role, Context context) {
        this.clearPermissionsCache();
        for (BIRoleListener rl : this.getRoleListeners()) {
            try {
                rl.changedRole(this, role.getRoleIdentifier());
            }
            catch (Exception e) {
                BRoleService.notificationError(rl, e);
            }
        }
    }

    private static void notificationError(BIRoleListener rl, Exception e) {
        log.warning("Error notifying role listener: " + rl + e.getMessage());
    }

    private BIRoleListener[] getRoleListeners() {
        BComponent parentComponent;
        BComplex parent = this.getParent();
        if (parent != null && (parentComponent = parent.getParentComponent()) != null) {
            return parentComponent.getChildren(BIRoleListener.class);
        }
        return new BIRoleListener[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPermissionsCache() {
        Object object = this.SUPERUSER_LOCK;
        synchronized (object) {
            this.superUsers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BIRole> getSuperuserRoles() {
        Object object = this.SUPERUSER_LOCK;
        synchronized (object) {
            if (this.superUsers == null) {
                this.superUsers = new HashMap<String, BIRole>();
                for (BIRole role : this.getChildren(BIRole.class)) {
                    if (!role.getPermissions().isSuperUser()) continue;
                    this.superUsers.put(role.getRoleIdentifier(), role);
                }
            }
            return this.superUsers;
        }
    }

    @Override
    public BIRole getRole(String roleIdentifier) {
        BValue child = this.get(roleIdentifier);
        if (child != null && child instanceof BIRole) {
            return (BIRole)((Object)child);
        }
        return null;
    }

    @Override
    public String getSourceIdentifier() {
        return DEFAULT_ROLE_SERVICE_NAMESPACE;
    }

    @Override
    public List<String> getRoleIds() {
        return this.getRoles(true);
    }

    @Override
    public List<String> getEnabledRoleIds() {
        return this.getRoles(false);
    }

    private List<String> getRoles(boolean all) {
        BIRole[] children = this.getChildren(BIRole.class);
        ArrayList<String> roles = new ArrayList<String>(children.length);
        for (BIRole role : children) {
            if (!all && !role.getEnabled()) continue;
            roles.add(role.getRoleIdentifier());
        }
        return roles;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

