/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query;

import com.tridium.collection.GenericColumn;
import com.tridium.data.DataColumnList;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.query.QueryPermissionCheckIterator;
import com.tridium.sys.tag.BEntityObjectWrapper;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.util.CloseableIterator;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BQueryResult
extends BObject
implements BITable<BIEntity> {
    public static final Type TYPE = Sys.loadType(BQueryResult.class);
    private static final Column entityOrdColumn = new GenericColumn("ord", Lexicon.make(BQueryResult.class).getText("ord"), BOrd.TYPE);
    private static final DataColumnList columns = new DataColumnList();
    private OrdQuery query;
    private OrdTarget scope;
    private BIQueryHandler queryHandler;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BQueryResult(OrdQuery query, OrdTarget scope, BIQueryHandler queryHandler) {
        this.query = query;
        this.scope = scope;
        this.queryHandler = queryHandler;
    }

    public OrdQuery getQuery() {
        return this.query;
    }

    public OrdTarget getScope() {
        return this.scope;
    }

    public BIQueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<Entity> getResults() {
        long start = DiagnosticUtil.startIfLoggable((String)"BQueryResult.getResults");
        try {
            QueryPermissionCheckIterator results = this.queryHandler.query(this.scope, this.query);
            if (this.scope.getUser() != null && !BIQueryHandler.TRUSTED_QUERY_HANDLERS.contains(this.queryHandler.getType().getTypeSpec())) {
                results = QueryPermissionCheckIterator.make(results, this.scope.getUser());
            }
            QueryPermissionCheckIterator queryPermissionCheckIterator = results;
            return queryPermissionCheckIterator;
        }
        finally {
            if (start > -1L) {
                DiagnosticUtil.complete((long)start, (String)"BQueryResult.getResults", (Object)(this.scope + ", " + this.query));
            }
        }
    }

    public Stream<Entity> stream() {
        CloseableIterator<Entity> it = this.getResults();
        Spliterator<Entity> split = Spliterators.spliteratorUnknownSize(it, 0);
        return (Stream)StreamSupport.stream(split, false).onClose(() -> {
            try {
                it.close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e);
            }
        });
    }

    @Override
    public TableCursor<BIEntity> cursor() {
        return new QueryResultTableCursor(this);
    }

    @Override
    public ColumnList getColumns() {
        return columns;
    }

    @Override
    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    static {
        columns.addColumn(entityOrdColumn);
    }

    private static class QueryResultTableRow
    extends AbstractRow<BIEntity> {
        QueryResultTableRow(BITable<BIEntity> table, BIEntity rowObject) {
            super(table, rowObject);
        }

        @Override
        public BIObject cell(Column column) {
            BIEntity entity = (BIEntity)this.rowObject();
            if (column == entityOrdColumn) {
                BOrd ord = entity instanceof BComponent ? ((BComponent)entity).getNavOrd() : (entity != null ? entity.getOrdToEntity().orElse(BOrd.NULL) : BOrd.NULL);
                return ord;
            }
            return entity;
        }

        @Override
        public Row<BIEntity> safeCopy() {
            return this;
        }
    }

    private static class QueryResultTableCursor
    extends AbstractTableCursor<BIEntity> {
        Entity current;
        CloseableIterator<Entity> entities;

        public QueryResultTableCursor(BQueryResult result) {
            super(result);
            this.entities = result.getResults();
        }

        @Override
        public Row<BIEntity> row() {
            return new QueryResultTableRow(this.getTable(), this.current != null ? BEntityObjectWrapper.makeEntityObject(this.current) : null);
        }

        @Override
        protected boolean advanceCursor() {
            this.current = this.entities.hasNext() ? (Entity)this.entities.next() : null;
            return this.current != null;
        }

        @Override
        protected void closeCursor() {
            try {
                this.entities.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

