/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BRootScheme;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public final class BNavRoot
extends BNavContainer {
    static final Logger eventLogger = Logger.getLogger("nav.event");
    public static final BNavRoot INSTANCE = new BNavRoot();
    public static final Type TYPE = Sys.loadType(BNavRoot.class);
    private static final BIcon icon;
    List<NavListener> listeners = new ArrayList<NavListener>();

    @Override
    public Type getType() {
        return TYPE;
    }

    private BNavRoot() {
        super("root", LexiconText.make("baja", "nav.root"));
    }

    @Override
    public BOrd getNavOrd() {
        return BRootScheme.ORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavListener[] getNavListeners() {
        NavListener[] r;
        List<NavListener> list = this.listeners;
        synchronized (list) {
            r = this.listeners.toArray(new NavListener[this.listeners.size()]);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavListener(NavListener listener) {
        List<NavListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != listener) continue;
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNavListener(NavListener listener) {
        List<NavListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != listener) continue;
                this.listeners.remove(i);
                break;
            }
        }
    }

    @Override
    public void fireNavEvent(NavEvent event) {
        if (eventLogger.isLoggable(Level.FINE)) {
            eventLogger.fine(event.toString());
        }
        NavListener[] x = this.getNavListeners();
        for (int i = 0; i < x.length; ++i) {
            try {
                x[i].navEvent(event);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        NavListener[] listeners = this.getNavListeners();
        out.startTable(false);
        out.trTitle("Listeners", 1);
        for (int i = 0; i < listeners.length; ++i) {
            out.tr(listeners[i]);
        }
        out.endTable();
    }

    static {
        BLocalHost.INSTANCE.getHostname();
        icon = BIcon.std("planet.png");
    }
}

