/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.util.EscUtil;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.Path;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.IllegalNameException;

public class SlotPath
implements OrdQuery,
Path {
    private static final String[] NO_NAMES = new String[0];
    private final String scheme;
    private final String body;
    private boolean abs;
    private int backupDepth;
    private String[] names = NO_NAMES;

    public SlotPath(String scheme, String body) throws SyntaxException {
        this.scheme = TextUtil.toLowerCase((String)scheme).trim();
        this.body = body.trim();
        this.parse();
    }

    public SlotPath(String scheme, String[] names) throws SyntaxException {
        this.scheme = TextUtil.toLowerCase((String)scheme).trim();
        this.abs = true;
        this.backupDepth = 0;
        this.names = names;
        if (names.length == 0) {
            this.body = "/";
        } else {
            StringBuilder s = new StringBuilder();
            for (String name : names) {
                s.append('/').append(name);
            }
            this.body = s.toString();
        }
    }

    public SlotPath(String body) throws SyntaxException {
        this.scheme = "slot";
        this.body = body.trim();
        this.parse();
    }

    protected SlotPath makeSlotPath(String scheme, String body) {
        return new SlotPath(scheme, body);
    }

    public boolean isAbsolute() {
        return this.abs;
    }

    public boolean isRelative() {
        return !this.abs;
    }

    @Override
    public int getBackupDepth() {
        return this.backupDepth;
    }

    @Override
    public Path getParentPath() {
        return this.getParent();
    }

    public SlotPath getParent() {
        if (this.names.length == 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        if (this.isAbsolute()) {
            s.append('/');
        } else {
            int backups = this.getBackupDepth();
            for (int i = 0; i < backups; ++i) {
                s.append("../");
            }
        }
        for (int i = 0; i < this.names.length - 1; ++i) {
            if (i > 0) {
                s.append('/');
            }
            s.append(this.names[i]);
        }
        return this.makeSlotPath(this.scheme, s.toString());
    }

    @Override
    public int depth() {
        return this.names.length;
    }

    @Override
    public String nameAt(int depth) {
        return this.names[depth];
    }

    @Override
    public String[] getNames() {
        return (String[])this.names.clone();
    }

    @Override
    public OrdQuery makePath(String body) {
        return new SlotPath(body);
    }

    protected boolean isValidPathName(String name) {
        return SlotPath.isValidName(name);
    }

    public static boolean isValidName(String name) {
        return EscUtil.slot.isValid(name);
    }

    public static void verifyValidName(String name) {
        if (!SlotPath.isValidName(name)) {
            throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{name});
        }
    }

    public static String escape(String s) {
        return EscUtil.slot.escape(s);
    }

    public static String unescape(String s) {
        return EscUtil.slot.unescape(s);
    }

    @Override
    public boolean isHost() {
        return false;
    }

    @Override
    public boolean isSession() {
        return false;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void normalize(OrdQueryList list, int index) {
        if (list.isSameScheme(index, index + 1)) {
            SlotPath append = (SlotPath)list.get(index + 1);
            list.merge(index, this.merge(append));
        }
    }

    public SlotPath merge(SlotPath a) {
        int i;
        if (a.isAbsolute()) {
            return a;
        }
        StringBuilder s = new StringBuilder();
        if (this.abs) {
            s.append('/');
        }
        if (a.getBackupDepth() > 0 && a.getBackupDepth() > this.depth()) {
            if (this.abs) {
                throw new SyntaxException("Invalid merge " + this + " + " + a);
            }
            int backups = a.getBackupDepth() - this.depth() + this.getBackupDepth();
            for (i = 0; i < backups; ++i) {
                s.append("../");
            }
        }
        boolean needSlash = false;
        for (i = 0; i < this.depth() - a.getBackupDepth(); ++i) {
            if (needSlash) {
                s.append('/');
            } else {
                needSlash = true;
            }
            s.append(this.nameAt(i));
        }
        for (i = 0; i < a.depth(); ++i) {
            if (needSlash) {
                s.append('/');
            } else {
                needSlash = true;
            }
            s.append(a.nameAt(i));
        }
        return this.makeSlotPath(this.scheme, s.toString());
    }

    public String toDisplayString() {
        return SlotPath.unescape(this.body);
    }

    @Override
    public String toString() {
        return this.scheme + ':' + this.body;
    }

    void parse() {
        try {
            if (this.body.isEmpty()) {
                return;
            }
            int start = 0;
            char c = this.body.charAt(0);
            if (c == '/') {
                this.abs = true;
                start = 1;
            } else if (c == '.') {
                start = this.parseBackup();
            }
            this.parseNames(start);
        }
        catch (SyntaxException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SyntaxException(e);
        }
    }

    void parseNames(int start) {
        String body = this.body;
        int len = body.length();
        if (start >= len) {
            return;
        }
        if (body.charAt(len - 1) == '/') {
            throw new SyntaxException("Trailing slash");
        }
        String[] temp = new String[64];
        int n = 0;
        for (int i = start; i < len; ++i) {
            char c = body.charAt(i);
            if (c != '/') continue;
            if (i == start) {
                throw new SyntaxException("Illegal double slashes");
            }
            String name = body.substring(start, i);
            if (!this.isValidPathName(name)) {
                throw new SyntaxException("Invalid name in path:" + name);
            }
            temp[n++] = name;
            start = i + 1;
        }
        String end = body.substring(start, len);
        if (!this.isValidPathName(end)) {
            throw new SyntaxException("Invalid name in path:" + end);
        }
        temp[n++] = end;
        this.names = new String[n];
        System.arraycopy(temp, 0, this.names, 0, n);
    }

    int parseBackup() {
        String body = this.body;
        int len = body.length();
        for (int i = 0; i < len; i += 3) {
            int c2;
            char c0 = body.charAt(i);
            int c1 = i + 1 < len ? (int)body.charAt(i + 1) : -1;
            int n = c2 = i + 2 < len ? (int)body.charAt(i + 2) : 47;
            if (c0 != '.') {
                return i;
            }
            if (c1 != 46 || c2 != 47) {
                if (this.isValidPathName(String.valueOf(c0))) {
                    return i;
                }
                throw new SyntaxException("Expecting ../ backup");
            }
            ++this.backupDepth;
        }
        return len;
    }
}

