/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.util.ArrayList;
import javax.baja.naming.OrdQuery;

public final class OrdQueryList {
    ArrayList<OrdQuery> list = new ArrayList();
    boolean modified;

    public OrdQueryList(OrdQuery[] q, int size) {
        this.list.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this.list.add(q[i]);
        }
    }

    public OrdQueryList(OrdQuery[] q) {
        this(q, q.length);
    }

    public OrdQueryList() {
    }

    public int size() {
        return this.list.size();
    }

    public OrdQuery get(int index) {
        return this.list.get(index);
    }

    public OrdQuery[] toArray() {
        return this.list.toArray(new OrdQuery[this.list.size()]);
    }

    public OrdQuery prev(int index) {
        if (index > 0 && !this.list.isEmpty()) {
            return this.list.get(index - 1);
        }
        return null;
    }

    public OrdQuery next(int index) {
        if (index + 1 < this.list.size()) {
            return this.list.get(index + 1);
        }
        return null;
    }

    public boolean isSameScheme(int indexA, int indexB) {
        if (0 <= indexA && indexA < this.list.size() && 0 <= indexB && indexB < this.list.size()) {
            OrdQuery a = this.list.get(indexA);
            OrdQuery b = this.list.get(indexB);
            return a.getClass() == b.getClass() && a.getScheme().equals(b.getScheme());
        }
        return false;
    }

    public void add(OrdQueryList list) {
        this.modified = true;
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
    }

    public void add(OrdQuery q) {
        this.modified = true;
        this.list.add(this.list.size(), q);
    }

    public void add(int index, OrdQuery q) {
        this.modified = true;
        this.list.add(index, q);
    }

    public void replace(int index, OrdQuery q) {
        this.modified = true;
        this.list.set(index, q);
    }

    public void remove(int index) {
        this.modified = true;
        this.list.remove(index);
    }

    public void clear() {
        this.modified = true;
        this.list.clear();
    }

    public void trim(int start) {
        this.trim(start, this.size());
    }

    public void trim(int start, int end) {
        if (start > 0 || end < this.list.size()) {
            int i;
            this.modified = true;
            int size = this.list.size();
            for (i = end; i < size; ++i) {
                this.list.remove(end);
            }
            for (i = 0; i < start; ++i) {
                this.list.remove(0);
            }
        }
    }

    public void merge(int index, OrdQuery merged) {
        this.modified = true;
        this.list.remove(index + 1);
        this.list.remove(index + 0);
        this.list.add(index, merged);
    }

    public void shiftToHost(int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (this.get(i).isHost()) continue;
            this.remove(i);
        }
    }

    public void shiftToSession(int index) {
        for (int i = index - 1; i >= 0; --i) {
            OrdQuery q = this.get(i);
            if (q.isHost() || q.isSession()) continue;
            this.remove(i);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                s.append('|');
            }
            s.append(this.list.get(i));
        }
        return s.toString();
    }
}

