/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

public class BatchResolve {
    BOrd[] ords;
    Result[] results;

    public BatchResolve(BOrd[] ords) {
        this.ords = (BOrd[])ords.clone();
        this.results = new Result[ords.length];
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = new Result();
        }
    }

    public int size() {
        return this.ords.length;
    }

    public BOrd getOrd(int index) {
        return this.ords[index];
    }

    public boolean isResolved(int index) {
        return this.results[index].target != null;
    }

    public Throwable getException(int index) {
        return this.results[index].exception;
    }

    public OrdTarget getTarget(int index) {
        Result result = this.results[index];
        OrdTarget t = result.target;
        if (t != null) {
            return t;
        }
        if (result.exception instanceof RuntimeException) {
            throw (RuntimeException)result.exception;
        }
        throw new UnresolvedException("" + this.ords[index], result.exception);
    }

    public BObject get(int index) {
        return this.getTarget(index).get();
    }

    public OrdTarget[] getTargets() {
        OrdTarget[] targets = new OrdTarget[this.results.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = this.getTarget(i);
        }
        return targets;
    }

    public BObject[] getTargetObjects() {
        OrdTarget[] targets = this.getTargets();
        BObject[] objects = new BObject[targets.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = targets[i].get();
        }
        return objects;
    }

    public BComponent[] getTargetComponents() {
        OrdTarget[] targets = this.getTargets();
        BComponent[] components = new BComponent[targets.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = (BComponent)targets[i].get();
        }
        return components;
    }

    public BatchResolve resolve(BObject base) {
        return this.resolve(base, null);
    }

    public BatchResolve resolve(BObject base, Context cx) {
        try {
            this.resolveComponentSpace(base, cx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.ords.length; ++i) {
            Result result = this.results[i];
            if (result.target != null || result.exception != null) continue;
            try {
                result.target = this.ords[i].resolve(base, cx);
                result.exception = null;
                continue;
            }
            catch (Throwable e) {
                result.target = null;
                result.exception = e;
            }
        }
        return this;
    }

    private void resolveComponentSpace(BObject base, Context cx) {
        int i;
        ComponentSpaceItem item;
        Array items = new Array(ComponentSpaceItem.class);
        for (int i2 = 0; i2 < this.ords.length; ++i2) {
            BOrd ord = this.ords[i2];
            if (ord.toString().indexOf("slot:") < 0 && ord.toString().indexOf("virtual:") < 0 && ord.toString().indexOf("h:") < 0 || (item = this.makeComponentSpaceItem(ord, base)) == null) continue;
            items.add((Object)item);
        }
        if (items.isEmpty()) {
            return;
        }
        Array groups = new Array(ComponentSpaceGroup.class);
        for (i = 0; i < items.size(); ++i) {
            item = (ComponentSpaceItem)items.get(i);
            BComponentSpace space = item.space;
            ComponentSpaceGroup group = null;
            for (int j = 0; j < groups.size(); ++j) {
                ComponentSpaceGroup g = (ComponentSpaceGroup)groups.get(j);
                if (g.space != space) continue;
                group = g;
                break;
            }
            if (group == null) {
                group = new ComponentSpaceGroup(space);
                groups.add((Object)group);
            }
            group.items.add((Object)item);
        }
        for (i = 0; i < groups.size(); ++i) {
            ComponentSpaceGroup group = (ComponentSpaceGroup)groups.get(i);
            this.resolveComponentSpaceGroup(group, base, cx);
        }
    }

    private ComponentSpaceItem makeComponentSpaceItem(BOrd ord, BObject base) {
        ComponentSpaceItem item = new ComponentSpaceItem(ord);
        OrdQuery[] queries = ord.normalize().parse();
        int foundIndex = -1;
        for (int i = 0; i < queries.length; ++i) {
            OrdQuery q = queries[i];
            String scheme = q.getScheme();
            if (scheme.equals("virtual")) {
                foundIndex = i;
                item.slot = q;
                break;
            }
            if (scheme.equals("h") && foundIndex == -1) {
                foundIndex = i;
                item.h = q;
            }
            if (!scheme.equals("slot") || foundIndex != -1) continue;
            foundIndex = i;
            item.slot = q;
        }
        if (foundIndex == -1) {
            return null;
        }
        BObject preObject = null;
        try {
            BOrd preOrd = BOrd.make(queries, 0, foundIndex);
            if (!preOrd.isNull()) {
                preObject = preOrd.get(base);
            }
        }
        catch (Exception preOrd) {
            // empty catch block
        }
        BComponentSpace space = null;
        if (preObject instanceof BComponentSpace) {
            space = (BComponentSpace)preObject;
        } else if (preObject instanceof BVirtualGateway) {
            space = ((BVirtualGateway)preObject).getVirtualSpace();
        } else {
            BSpace baseSpace = BOrd.toSpace(base);
            if (baseSpace instanceof BComponentSpace) {
                space = (BComponentSpace)baseSpace;
            }
        }
        if (space == null) {
            return null;
        }
        item.space = space;
        return item;
    }

    private void resolveComponentSpaceGroup(ComponentSpaceGroup group, BObject base, Context cx) {
        BComponentSpace space = group.space;
        ComponentSpaceItem[] items = (ComponentSpaceItem[])group.items.trim();
        Array handleItems = new Array(ComponentSpaceItem.class);
        for (int i = 0; i < items.length; ++i) {
            ComponentSpaceItem item = items[i];
            if (item.slot != null) {
                item.path = this.toSlotPath(item.slot, base);
                continue;
            }
            handleItems.add((Object)item);
        }
        if (!handleItems.isEmpty()) {
            Object[] handles = new Object[handleItems.size()];
            for (int i = 0; i < handleItems.size(); ++i) {
                ComponentSpaceItem item = (ComponentSpaceItem)handleItems.get(i);
                handles[i] = item.h.getBody();
            }
            SlotPath[] handlePaths = space.handlesToSlotPaths(handles);
            for (int i = 0; i < handleItems.size(); ++i) {
                ComponentSpaceItem item = (ComponentSpaceItem)handleItems.get(i);
                item.path = handlePaths[i];
            }
        }
        Array pathsAcc = new Array(SlotPath.class);
        for (int i = 0; i < items.length; ++i) {
            ComponentSpaceItem item = items[i];
            if (item.path == null) continue;
            pathsAcc.add((Object)item.path);
        }
        SlotPath[] paths = (SlotPath[])pathsAcc.trim();
        space.fw(104, paths, null, null, null);
    }

    SlotPath toSlotPath(OrdQuery q, BObject base) {
        SlotPath path = null;
        boolean isVirtual = q.getScheme().equals("virtual");
        path = isVirtual ? new VirtualPath(q.getBody()) : new SlotPath(q.getBody());
        if (path.isAbsolute()) {
            return path;
        }
        if (base instanceof BComponent && !isVirtual) {
            SlotPath basePath = ((BComponent)base).getSlotPath();
            return basePath.merge(path);
        }
        return null;
    }

    static class Result {
        OrdTarget target;
        Throwable exception;

        Result() {
        }
    }

    static class ComponentSpaceItem {
        BOrd ord;
        OrdQuery h;
        OrdQuery slot;
        BComponentSpace space;
        SlotPath path;

        ComponentSpaceItem(BOrd ord) {
            this.ord = ord;
        }
    }

    static class ComponentSpaceGroup {
        BComponentSpace space;
        Array<ComponentSpaceItem> items = new Array(ComponentSpaceItem.class);

        ComponentSpaceGroup(BComponentSpace space) {
            this.space = space;
        }
    }
}

