/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.virtual.BUnresolvedVirtualHandler;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BITemplate;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

public class BSlotScheme
extends BOrdScheme {
    public static final BSlotScheme INSTANCE = new BSlotScheme();
    public static final Type TYPE = Sys.loadType(BSlotScheme.class);

    private BSlotScheme() {
        super("slot");
    }

    protected BSlotScheme(String id) {
        super(id);
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new SlotPath(this.getId(), queryBody);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        OrdTarget target = null;
        RuntimeException ex = null;
        try {
            target = this.doResolve(base, query);
        }
        catch (RuntimeException e) {
            ex = e;
        }
        if (target == null) {
            try {
                BObject baseObject = base.get();
                BVirtualGateway gateway = null;
                if (baseObject.getType().is(BVirtualGateway.TYPE)) {
                    gateway = (BVirtualGateway)baseObject;
                } else if (baseObject.getType().is(BVirtualComponentSpace.TYPE)) {
                    gateway = ((BVirtualComponentSpace)baseObject).getVirtualGateway();
                } else if (FoxVirtualSpaceHolder.FOX_VIRTUAL_SPACE_TYPE != null && baseObject.getType().is(FoxVirtualSpaceHolder.FOX_VIRTUAL_SPACE_TYPE)) {
                    gateway = (BVirtualGateway)((BINavNode)((Object)baseObject)).getNavParent();
                }
                if (gateway != null) {
                    AgentList unresolvedVirtualHandlers = gateway.getAgents(base).filter(info -> info.getAgentType().is(BUnresolvedVirtualHandler.TYPE));
                    for (AgentInfo info2 : unresolvedVirtualHandlers) {
                        target = ((BUnresolvedVirtualHandler)info2.getInstance()).resolveFailedVirtualQuery(base, query);
                        if (target == null) continue;
                        return target;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ex != null) {
                throw ex;
            }
        }
        return target;
    }

    private OrdTarget doResolve(OrdTarget base, OrdQuery query) {
        int i;
        BIPropertyContainer startContainer;
        BObject baseObject = base.get();
        BIPropertyContainer baseContainer = null;
        boolean baseContainerMayReallyBeParent = false;
        SlotPath path = (SlotPath)query;
        boolean isVirtualPath = path instanceof VirtualPath;
        BComponentSpace space = null;
        if (baseObject instanceof BVirtualGateway && isVirtualPath) {
            space = ((BVirtualGateway)baseObject).getVirtualSpace();
            baseContainer = space.getRootComponent();
        } else if (baseObject instanceof BComponentSpace) {
            space = (BComponentSpace)baseObject;
            baseContainer = space.getRootComponent();
        } else if (baseObject instanceof BComponent) {
            BComponent first;
            BComponent[] children;
            BComponent baseComponent = baseObject.asComponent();
            space = baseComponent.getComponentSpace();
            if (path.isAbsolute() && (baseComponent = space.getRootComponent()) instanceof BUnrestrictedFolder && ((children = baseComponent.getChildComponents()).length == 1 || children.length == 2) && (first = children[0]) instanceof BStation) {
                baseComponent = first;
                baseContainerMayReallyBeParent = true;
            }
            baseContainer = baseComponent;
        } else if (baseObject instanceof BIPropertyContainer) {
            baseContainer = (BIPropertyContainer)((Object)baseObject);
        } else if (baseObject instanceof BITemplate) {
            baseContainer = ((BITemplate)((Object)baseObject)).getBaseComponent();
        }
        if (isVirtualPath && path.getBody().equals("")) {
            return new OrdTarget(base, space);
        }
        BObject value = (BObject)((Object)baseContainer);
        if (value == null) {
            if (!(baseObject instanceof BValue)) {
                throw new InvalidOrdBaseException("" + baseObject);
            }
            value = baseObject;
        }
        BIPropertyContainer container = startContainer = baseContainer;
        Slot slot = null;
        int depth = path.depth();
        Property[] propPath = null;
        int pathDepth = 0;
        int backupDepth = path.getBackupDepth();
        for (i = 0; i < backupDepth; ++i) {
            value = (BObject)((Object)(container = container instanceof BComponent ? (BComponent)((BComplex)((Object)container)).getParent() : null));
            if (value != null) continue;
            throw new UnresolvedException("Cannot walk backup depth" + baseObject);
        }
        for (i = 0; i < depth; ++i) {
            String nameAtDepth = path.nameAt(i);
            if (isVirtualPath) {
                nameAtDepth = VirtualPath.toSlotPathName(nameAtDepth);
            }
            boolean performLoadSlots = true;
            if (space != null && value.isComponent()) {
                slot = space.getLoadCallbacks().loadSlot(value.asComponent(), nameAtDepth);
                performLoadSlots = slot == null;
            }
            boolean isPropContainer = value instanceof BIPropertyContainer;
            if (performLoadSlots) {
                if (isPropContainer) {
                    ((BIPropertyContainer)((Object)value)).loadSlots();
                    slot = ((BIPropertyContainer)((Object)value)).getSlot(nameAtDepth);
                } else {
                    value.asComplex().loadSlots();
                    slot = value.asComplex().getSlot(nameAtDepth);
                }
            }
            if (slot == null && baseContainerMayReallyBeParent) {
                baseContainerMayReallyBeParent = false;
                i = -1;
                container = (BComponent)((BComponent)startContainer).getParent();
                value = (BObject)((Object)container);
                propPath = null;
                pathDepth = 0;
                continue;
            }
            if (slot == null) {
                throw new UnresolvedException(path.getBody());
            }
            if (!(slot instanceof Property)) {
                if (i != depth - 1) {
                    throw new UnresolvedException(path.getBody());
                }
                return new OrdTarget(base, container, null, slot, null);
            }
            Property prop = (Property)slot;
            BObject bObject = value = isPropContainer ? ((BIPropertyContainer)((Object)value)).get(prop) : value.asComplex().get(prop);
            if (pathDepth == 0 && value instanceof BIPropertyContainer) {
                container = (BIPropertyContainer)((Object)value);
                continue;
            }
            if (propPath == null) {
                propPath = new Property[32];
            }
            propPath[pathDepth++] = prop;
        }
        if (pathDepth == 0) {
            return new OrdTarget(base, (BObject)((Object)container));
        }
        slot = propPath[0];
        Property[] resize = new Property[pathDepth];
        System.arraycopy(propPath, 0, resize, 0, pathDepth);
        return new OrdTarget(base, container, value, slot, resize);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private static final class FoxVirtualSpaceHolder {
        static final TypeInfo FOX_VIRTUAL_SPACE_TYPE;

        private FoxVirtualSpaceHolder() {
        }

        static {
            TypeInfo foxVirtualSpaceType = null;
            try {
                foxVirtualSpaceType = Sys.getType("fox:FoxVirtualSpace").getTypeInfo();
            }
            catch (Exception e) {
                foxVirtualSpaceType = null;
            }
            FOX_VIRTUAL_SPACE_TYPE = foxVirtualSpaceType;
        }
    }
}

