/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BOrdList
extends BSimple
implements Iterable<BOrd> {
    public static final BOrdList NULL;
    public static final BOrdList DEFAULT;
    public static final Type TYPE;
    private int hashCode = -1;
    private BOrd[] ords;
    private String string;

    public static BOrdList make(BOrd ord) {
        return new BOrdList(new BOrd[]{ord}, ord.encodeToString());
    }

    public static BOrdList make(BOrd ... ords) {
        if (ords.length == 0) {
            return NULL;
        }
        return new BOrdList((BOrd[])ords.clone(), null);
    }

    public static BOrdList add(BOrdList orig, BOrd ord) {
        BOrd[] ords = new BOrd[orig.ords.length + 1];
        System.arraycopy(orig.ords, 0, ords, 0, orig.ords.length);
        ords[ords.length - 1] = ord;
        return new BOrdList(ords, null);
    }

    public static BOrdList remove(BOrdList orig, int index) {
        BOrd[] ords = new BOrd[orig.ords.length - 1];
        System.arraycopy(orig.ords, 0, ords, 0, index);
        if (index < orig.ords.length) {
            System.arraycopy(orig.ords, index + 1, ords, index, orig.ords.length - index - 1);
        }
        return new BOrdList(ords, null);
    }

    public static BOrdList make(String string) {
        return (BOrdList)DEFAULT.decodeFromString(string);
    }

    private BOrdList(BOrd[] ords, String string) {
        this.ords = ords;
        this.string = string;
    }

    public BOrd get(int index) {
        return this.ords[index];
    }

    public int size() {
        return this.ords.length;
    }

    @Override
    public boolean isNull() {
        return this.ords.length == 0;
    }

    public BOrd[] toArray() {
        return (BOrd[])this.ords.clone();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            int x = 11;
            for (int i = 0; i < this.ords.length; ++i) {
                x ^= this.ords[i].hashCode();
            }
            this.hashCode = x;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BOrdList) {
            BOrd[] a = this.ords;
            BOrd[] b = ((BOrdList)obj).ords;
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        if (this.string == null) {
            if (this.ords.length == 1) {
                this.string = this.ords[0].encodeToString();
            } else {
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < this.ords.length; ++i) {
                    if (i > 0) {
                        s.append('\n');
                    }
                    s.append(this.ords[i].encodeToString());
                }
                this.string = s.toString();
            }
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) {
        if (s.isEmpty()) {
            return DEFAULT;
        }
        int nl = s.indexOf(10);
        if (nl < 0) {
            return new BOrdList(new BOrd[]{BOrd.make(s)}, s);
        }
        ArrayList<BOrd> list = new ArrayList<BOrd>();
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            list.add(BOrd.make(st.nextToken()));
        }
        BOrd[] ords = list.toArray(new BOrd[list.size()]);
        return new BOrdList(ords, s);
    }

    @Override
    public Iterator<BOrd> iterator() {
        return new Iterator<BOrd>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BOrdList.this.ords.length;
            }

            @Override
            public BOrd next() {
                if (this.index > BOrdList.this.ords.length) {
                    throw new NoSuchElementException();
                }
                BOrd result = BOrdList.this.ords[this.index];
                ++this.index;
                return result;
            }
        };
    }

    @Override
    public String toString(Context cx) {
        if (this.ords.length == 1) {
            return this.ords[0].toString(cx);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.ords.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(this.ords[i].toString(cx));
        }
        return buf.toString();
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BOrdList(new BOrd[0], "");
        TYPE = Sys.loadType(BOrdList.class);
    }
}

