/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.authn.AuthenticationClient;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BHost;
import javax.baja.naming.BIAlias;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.Path;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BOrd
extends BSimple
implements BIComparable,
BIAlias,
BIDataValue {
    public static final BOrd NULL;
    public static final BOrd DEFAULT;
    public static final Type TYPE;
    int hashCode = -1;
    String string;

    public static BOrd make(String s) {
        if (s.equals("null")) {
            return NULL;
        }
        return new BOrd(s);
    }

    public static BOrd make(BOrd base, BOrd child) {
        if (base.toString().isEmpty()) {
            return child;
        }
        if (child.toString().isEmpty()) {
            return base;
        }
        if (base.isNull()) {
            throw new NullOrdException("base");
        }
        if (child.isNull()) {
            throw new NullOrdException("child");
        }
        return new BOrd(base.string + '|' + child.string);
    }

    public static BOrd make(BOrd base, String child) {
        return BOrd.make(base, BOrd.make(child));
    }

    public static BOrd make(BOrd base, OrdQuery child) {
        return BOrd.make(base, BOrd.make(child));
    }

    public static BOrd make(OrdQuery query) {
        return BOrd.make(new OrdQuery[]{query});
    }

    public static BOrd make(OrdQuery[] queries) {
        return BOrd.make(queries, 0, queries.length);
    }

    public static BOrd make(OrdQuery[] queries, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        StringBuffer s = new StringBuffer();
        for (int i = start; i < end; ++i) {
            OrdQuery q = queries[i];
            String body = q.getBody();
            if (i > start) {
                s.append('|');
            }
            s.append(q.getScheme()).append(':').append(q.getBody());
        }
        return new BOrd(s.toString());
    }

    private BOrd(String string) {
        this.string = string;
    }

    public BObject get() {
        return this.resolve(BLocalHost.INSTANCE, null).get();
    }

    public BObject get(BObject base) {
        return this.resolve(base).get();
    }

    public BObject get(BObject base, Context cx) {
        return this.resolve(base, cx).get();
    }

    public OrdTarget resolve() {
        return this.resolve(BLocalHost.INSTANCE, null);
    }

    public OrdTarget resolve(BObject base) {
        return this.resolve(base, null);
    }

    public OrdTarget resolve(BObject base, Context cx) throws NullOrdException, UnknownSchemeException, SyntaxException, UnresolvedException {
        return this.resolve(base, cx, null);
    }

    public OrdTarget resolve(BObject base, Context cx, AuthenticationClient client) throws NullOrdException, UnknownSchemeException, SyntaxException, UnresolvedException {
        if (base == null) {
            base = BLocalHost.INSTANCE;
        }
        OrdQuery[] queries = this.parse();
        if (this.isNull() || queries.length == 0) {
            throw new NullOrdException();
        }
        OrdQueryList list = new OrdQueryList(queries);
        while (BOrd.normalize(list)) {
        }
        queries = list.toArray();
        OrdTarget target = new OrdTarget(cx, this, queries, base);
        for (int i = 0; i < queries.length; ++i) {
            OrdQuery q = queries[i];
            BOrdScheme scheme = BOrdScheme.lookup(q.getScheme());
            target = scheme.resolve(target, q, client);
            if (target != null) continue;
            throw new UnresolvedException(this.string);
        }
        return target;
    }

    public static BHost toHost(BObject object) {
        if (object instanceof BHost) {
            return (BHost)object;
        }
        if (object instanceof BISession) {
            return ((BISession)((Object)object)).getHost();
        }
        if (object instanceof BSpace) {
            return ((BSpace)object).getHost();
        }
        if (object instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)object)).getHost();
        }
        return null;
    }

    public static BISession toSession(BObject object) {
        if (object instanceof BISession) {
            return (BISession)((Object)object);
        }
        if (object instanceof BSpace) {
            return ((BSpace)object).getSession();
        }
        if (object instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)object)).getSession();
        }
        return null;
    }

    public static BSpace toSpace(BObject object) {
        if (object instanceof BSpace) {
            return (BSpace)object;
        }
        if (object instanceof BISpaceNode) {
            return ((BISpaceNode)((Object)object)).getSpace();
        }
        return null;
    }

    public OrdQuery[] parse() {
        if (this.isNull()) {
            throw new NullOrdException();
        }
        OrdQuery[] temp = new OrdQuery[32];
        int n = 0;
        String string = this.string;
        int len = string.length();
        int lastPipe = 0;
        int lastNonSpace = 0;
        int colon = -1;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                throw new SyntaxException("Invalid ord char 0x" + Integer.toHexString(c));
            }
            if (c == ' ') {
                if (i != lastPipe) continue;
                lastPipe = i + 1;
                continue;
            }
            if (c == '|') {
                temp[n++] = BOrd.parse(string, lastPipe, lastNonSpace, colon);
                lastPipe = i + 1;
                lastNonSpace = i + 1;
                colon = -1;
                continue;
            }
            if (c == ':' && colon < 0) {
                colon = i;
            }
            lastNonSpace = i;
        }
        if (lastPipe < len) {
            temp[n++] = BOrd.parse(string, lastPipe, lastNonSpace, colon);
        }
        OrdQuery[] trim = new OrdQuery[n];
        System.arraycopy(temp, 0, trim, 0, n);
        return trim;
    }

    static OrdQuery parse(String s, int lastPipe, int lastNonSpace, int colon) {
        if (colon < 0) {
            throw new SyntaxException("Missing scheme name: " + s);
        }
        String scheme = s.substring(lastPipe, colon);
        String body = s.substring(colon + 1, lastNonSpace + 1);
        return BOrd.parse(scheme, body);
    }

    public static OrdQuery parse(String scheme, String body) {
        scheme = TextUtil.toLowerCase((String)scheme);
        body = body.trim();
        try {
            return BOrdScheme.lookup(scheme).parse(body);
        }
        catch (UnknownSchemeException e) {
            return new BasicQuery(scheme, body);
        }
        catch (SyntaxException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SyntaxException(e);
        }
    }

    public BOrd getParent() {
        OrdQuery[] q = this.parse();
        int lastIndex = q.length - 1;
        if (lastIndex >= q.length || lastIndex < 0) {
            return null;
        }
        OrdQuery lastQuery = q[lastIndex];
        if (lastQuery instanceof ViewQuery) {
            if (--lastIndex >= q.length || lastIndex < 0) {
                return null;
            }
            lastQuery = q[lastIndex];
        }
        if (!(lastQuery instanceof Path)) {
            return null;
        }
        Path path = (Path)((Object)lastQuery);
        Path parent = path.getParentPath();
        if (parent == null) {
            return null;
        }
        q[lastIndex] = (OrdQuery)((Object)parent);
        return BOrd.make(q, 0, lastIndex + 1);
    }

    public BOrd normalize() {
        OrdQueryList list = new OrdQueryList(this.parse());
        while (BOrd.normalize(list)) {
        }
        for (int i = 0; i < list.size(); ++i) {
            BOrdScheme.lookup(list.get(i).getScheme());
        }
        return BOrd.make(list.toArray());
    }

    public BOrd relativizeToHost() {
        OrdQueryList list = new OrdQueryList(this.parse());
        while (BOrd.normalize(list)) {
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.get(i).isHost()) continue;
            list.trim(i + 1);
            break;
        }
        return BOrd.make(list.toArray());
    }

    public BOrd relativizeToSession() {
        OrdQueryList list = new OrdQueryList(this.parse());
        while (BOrd.normalize(list)) {
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!list.get(i).isHost() && !list.get(i).isSession()) continue;
            list.trim(i + 1);
            break;
        }
        return BOrd.make(list.toArray());
    }

    private static boolean normalize(OrdQueryList list) {
        list.modified = false;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            OrdQuery q = list.get(i);
            q.normalize(list, i);
            if (!list.modified) continue;
            return true;
        }
        return false;
    }

    public BOrd substitute(BFacets varMap) throws Exception {
        final BFacets f = varMap;
        final StringBuffer result = new StringBuffer();
        this.scanForVariables(new Scanner(){

            @Override
            public void handleVariable(String key) {
                String val = f.gets(key, null);
                if (val == null) {
                    result.append("$(").append(key).append(")");
                } else {
                    result.append(val);
                }
            }

            @Override
            public void appendChar(char ch) {
                result.append(ch);
            }
        });
        return BOrd.make(result.toString());
    }

    public boolean hasVariables() {
        final boolean[] result = new boolean[]{false};
        this.scanForVariables(new Scanner(){

            @Override
            public void handleVariable(String key) {
                result[0] = true;
            }

            @Override
            public void appendChar(char ch) {
            }
        });
        return result[0];
    }

    public String[] getVariables() {
        final ArrayList arr = new ArrayList();
        this.scanForVariables(new Scanner(){

            @Override
            public void handleVariable(String key) {
                arr.add(key);
            }

            @Override
            public void appendChar(char ch) {
            }
        });
        return arr.toArray(new String[arr.size()]);
    }

    private void scanForVariables(Scanner scanner) {
        StringBuffer temp = new StringBuffer();
        int len = this.string.length();
        for (int i = 0; i < len; ++i) {
            int peek;
            char curr = this.string.charAt(i);
            int n = peek = i < len - 1 ? (int)this.string.charAt(i + 1) : -1;
            if (curr == '$' && peek == 40) {
                temp.setLength(0);
                if ((i += 2) >= len) {
                    throw new SyntaxException("Missing closing paren");
                }
                curr = this.string.charAt(i);
                while (curr != ')') {
                    if (i >= len - 1) {
                        throw new SyntaxException("Missing closing paren");
                    }
                    boolean valid = false;
                    if (curr >= 'A' && curr <= 'Z') {
                        valid = true;
                    } else if (curr >= 'a' && curr <= 'z') {
                        valid = true;
                    } else if (curr >= '0' && curr <= '9') {
                        valid = true;
                    }
                    if (!valid) {
                        throw new SyntaxException("Illegal character in variable name: '" + (char)curr + "'");
                    }
                    temp.append(curr);
                    curr = this.string.charAt(++i);
                }
                String key = temp.toString();
                if (key.isEmpty()) {
                    throw new SyntaxException("Empty variable name");
                }
                scanner.handleVariable(key);
                continue;
            }
            scanner.appendChar(curr);
        }
    }

    public final BOrd getSubOrd(int start) {
        OrdQuery[] q = this.parse();
        return BOrd.make(q, start, q.length);
    }

    public final BOrd getSubOrd(int start, int end) {
        OrdQuery[] q = this.parse();
        return BOrd.make(q, start, end);
    }

    @Override
    public BOrd getOrd() {
        return this;
    }

    @Override
    public boolean isNull() {
        return this == NULL;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = TextUtil.toLowerCase((String)this.string).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BOrd) {
            return this.string.equals(((BOrd)obj).string);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        return this.string.compareTo(((BOrd)obj).string);
    }

    @Override
    public String toString(Context context) {
        return this.string;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.string);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BOrd.make(in.readUTF());
    }

    @Override
    public String encodeToString() {
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return BOrd.make(s);
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BOrd("null");
        TYPE = Sys.loadType(BOrd.class);
    }

    private static interface Scanner {
        public void handleVariable(String var1);

        public void appendChar(char var1);
    }
}

