/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import com.tridium.util.ThrowableUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public final class JobLogItem {
    public static final int MESSAGE = 0;
    public static final int RUNNING = 1;
    public static final int CANCELED = 2;
    public static final int SUCCESS = 3;
    public static final int FAILED = 4;
    private static final String[] IDS = new String[]{"Message", "Running", "Canceled", "Success", "Failed"};
    private DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy");
    int id;
    BAbsTime timestamp;
    String message;
    String details;

    public JobLogItem(int id, BAbsTime timestamp, String messageFormatPattern, String details) {
        if (id < 0 || id >= IDS.length || messageFormatPattern == null) {
            throw new IllegalArgumentException();
        }
        if (details != null && details.length() == 0) {
            details = null;
        }
        this.id = id;
        this.timestamp = timestamp;
        this.message = messageFormatPattern;
        this.details = details;
    }

    public JobLogItem(int id, String messageFormatPattern, Throwable exception) {
        this(id, BAbsTime.make(), messageFormatPattern, ThrowableUtil.dumpToString(exception));
    }

    public JobLogItem(int id, String lexModule, String lexKey, String[] lexArgPatterns, Throwable exception) {
        this(id, BAbsTime.make(), BFormat.getLexiconPattern(lexModule, lexKey, lexArgPatterns), ThrowableUtil.dumpToString(exception));
    }

    public JobLogItem(int id, String messageFormatPattern, String details) {
        this(id, BAbsTime.make(), messageFormatPattern, details);
    }

    public JobLogItem(int id, String lexModule, String lexKey, String[] lexArgPatterns, String details) {
        this(id, BAbsTime.make(), BFormat.getLexiconPattern(lexModule, lexKey, lexArgPatterns), details);
    }

    public JobLogItem(int id, String messageFormatPattern) {
        this(id, BAbsTime.make(), messageFormatPattern, null);
    }

    public JobLogItem(int id, String lexModule, String lexKey, String[] lexArgPatterns) {
        this(id, BAbsTime.make(), BFormat.getLexiconPattern(lexModule, lexKey, lexArgPatterns), null);
    }

    public int getId() {
        return this.id;
    }

    public String getIdString() {
        return this.getIdString(null);
    }

    public String getIdStringPattern() {
        return IDS[this.id];
    }

    public String getIdString(Context cx) {
        return Lexicon.make("baja", cx).get(IDS[this.id].toLowerCase());
    }

    public BAbsTime getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.getMessage(null);
    }

    public String getMessagePattern() {
        return this.message;
    }

    public String getMessage(Context cx) {
        return BFormat.format(this.message, this, cx);
    }

    public String getDetails() {
        return this.getDetails(null);
    }

    public String getDetailsPattern() {
        return this.details;
    }

    public String getDetails(Context cx) {
        if (this.details == null) {
            return null;
        }
        return BFormat.format(this.details, this, cx);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Context cx) {
        String s = this.getIdString(cx) + " [" + this.format.format(new Date(this.timestamp.getMillis())) + "] " + this.getMessage(cx);
        if (this.details != null) {
            s = s + "\n" + this.getDetails(cx);
        }
        return s;
    }

    public String encode() {
        StringBuffer s = new StringBuffer();
        s.append(IDS[this.id]).append('|').append(this.timestamp.encodeToString()).append('|').append(JobLogItem.escape(this.message)).append('|').append(JobLogItem.escape(this.details == null ? "" : this.details));
        return s.toString();
    }

    public static JobLogItem decode(String line) throws Exception {
        String[] tok = JobLogItem.unescape(line);
        String idStr = tok[0];
        String tsStr = tok[1];
        String message = tok[2];
        String details = tok[3];
        int id = 0;
        for (int i = 0; i < IDS.length; ++i) {
            if (!idStr.equals(IDS[i])) continue;
            id = i;
            break;
        }
        BAbsTime ts = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(tsStr);
        return new JobLogItem(id, ts, message, details);
    }

    static String escape(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == '|') {
                buf.append("\\|");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static String[] unescape(String s) {
        String[] r = new String[10];
        StringBuffer buf = new StringBuffer();
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if ((c = s.charAt(++i)) == 'n') {
                    buf.append('\n');
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '|') {
                r[n++] = buf.toString();
                buf = new StringBuffer();
                continue;
            }
            buf.append(c);
        }
        r[n++] = buf.toString();
        return r;
    }
}

