/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BZipFileDirectory
extends BAbstractFileStore {
    public static final Type TYPE = Sys.loadType(BZipFileDirectory.class);
    private Map<String, BIFile> byName = new HashMap<String, BIFile>();
    private BIFile[] byList = null;

    public BZipFileDirectory(BZipSpace space, FilePath path) {
        super(space, path);
    }

    BDirectory getOrMakeDir(String name) {
        BDirectory dir = (BDirectory)this.byName.get(name);
        if (dir == null) {
            BZipSpace space = (BZipSpace)this.getFileSpace();
            FilePath path = this.getFilePath().merge(name);
            BZipFileDirectory store = new BZipFileDirectory(space, path);
            dir = new BDirectory(store);
            this.byName.put(name, dir);
        }
        return dir;
    }

    BIFile get(String name) {
        return this.byName.get(name);
    }

    BIFile[] list() {
        if (this.byList == null) {
            this.byList = this.byName.values().toArray(new BIFile[this.byName.size()]);
            SortUtil.sort((Object[])this.byList);
        }
        return this.byList;
    }

    public void add(BIFile file) {
        this.byName.put(file.getFileName(), file);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

