/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.file.BDataFile;
import javax.baja.file.BIFileStore;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.space.BSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSubSpaceFile
extends BDataFile {
    public static final Type TYPE = Sys.loadType(BSubSpaceFile.class);
    public static final Logger log = Logger.getLogger("subSpaceFile");
    private static final Map<BOrd, CacheItem> cache = new HashMap<BOrd, CacheItem>();

    public BSubSpaceFile(BIFileStore store) {
        super(store);
    }

    public BSubSpaceFile() {
    }

    public boolean isOpen() {
        return cache.get(this.getAbsoluteOrd()) != null;
    }

    public BSpace getSubSpace() {
        CacheItem item = cache.get(this.getAbsoluteOrd());
        return item != null ? item.space : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BSubSpaceFile[] listOpen() {
        Map<BOrd, CacheItem> map = cache;
        synchronized (map) {
            CacheItem[] items = cache.values().toArray(new CacheItem[cache.size()]);
            BSubSpaceFile[] files = new BSubSpaceFile[items.length];
            for (int i = 0; i < files.length; ++i) {
                log.fine("ListIsOpen[" + i + "]: " + items[i].file.getAbsoluteOrd());
                files[i] = items[i].file;
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BSpace open() {
        Map<BOrd, CacheItem> map = cache;
        synchronized (map) {
            BOrd key = this.getAbsoluteOrd();
            CacheItem item = cache.get(key);
            if (item != null) {
                if (item.openTimestamp != this.getLastModified().getMillis()) {
                    log.warning("File has been modified: " + item.file);
                    this.close(false);
                } else {
                    return item.space;
                }
            }
            log.fine("Open: " + key);
            item = new CacheItem();
            item.space = this.doOpen();
            item.file = this;
            item.openTimestamp = this.getLastModified().getMillis();
            cache.put(key, item);
            return item.space;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        CacheItem item;
        Map<BOrd, CacheItem> map = cache;
        synchronized (map) {
            BOrd key = this.getAbsoluteOrd();
            log.fine("Save: " + key);
            item = cache.get(key);
        }
        if (item != null) {
            item.file.doSave();
            item.openTimestamp = item.file.getLastModified().getMillis();
        }
    }

    public void reload() throws Exception {
        this.close(false);
        this.open();
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean close) {
        BINavNode navParent;
        CacheItem item;
        Map<BOrd, CacheItem> map = cache;
        synchronized (map) {
            BOrd key = this.getAbsoluteOrd();
            log.fine("Close: " + key);
            item = cache.get(key);
            if (item != null) {
                log.fine("isModified: " + item.file.isModified());
                item.file.doClose();
                item.openTimestamp = 0L;
                cache.remove(key);
            }
        }
        if (item != null && (navParent = item.file.getNavParent()) != null) {
            BOrd parent = navParent.getNavOrd();
            String filename = item.file.getFileName();
            BFacets context = close ? BFacets.make("close", BBoolean.TRUE) : BFacets.NULL;
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced(parent, filename, (Context)context));
        }
    }

    public abstract boolean isModified();

    protected abstract BSpace doOpen();

    protected abstract void doSave() throws Exception;

    protected abstract void doClose();

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String name) {
        return this.open().getNavChild(name);
    }

    @Override
    public BINavNode[] getNavChildren() {
        return this.open().getNavChildren();
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static class CacheItem {
        public long openTimestamp;
        public BSubSpaceFile file;
        public BSpace space;

        CacheItem() {
        }
    }
}

