/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import javax.baja.agent.AgentList;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class BDirectory
extends BAbstractFile
implements BIDirectory {
    private static final BIcon defaultIcon = BIcon.std("folder.png");
    public static final Type TYPE = Sys.loadType(BDirectory.class);
    private LexiconText lexText;
    BIcon icon;
    BINavNode navParent;

    public BDirectory(BIFileStore store, LexiconText lexText) {
        super(store);
        this.lexText = lexText;
    }

    public BDirectory(BIFileStore store) {
        super(store);
    }

    public BDirectory() {
    }

    @Override
    public BIFile[] listFiles() {
        return this.getFileSpace().getChildren(this);
    }

    @Override
    public String getMimeType() {
        return "application/x-baja-directory";
    }

    public LexiconText getLexiconText() {
        return this.lexText;
    }

    public void setLexiconText(LexiconText lexText) {
        this.lexText = lexText;
    }

    @Override
    public String getNavDisplayName(Context cx) {
        if (this.lexText != null) {
            return this.lexText.getText(cx);
        }
        return this.getNavName();
    }

    @Override
    public String getNavDescription(Context cx) {
        if (this.lexText != null) {
            return Lexicon.make(this.lexText.module, cx).get(this.lexText.key + ".description", null);
        }
        return null;
    }

    @Override
    public BINavNode getNavParent() {
        if (this.navParent != null) {
            return this.navParent;
        }
        return super.getNavParent();
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        return this.getFileSpace().getChild(this, navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        return this.getFileSpace().getChildren(this);
    }

    @Override
    public BIcon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return defaultIcon;
    }

    public void setIcon(BIcon icon) {
        this.icon = icon;
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:DirectoryList");
        agents.toTop("hx:HxDirectoryView");
        agents.toBottom("web:FileUploadView");
        return agents;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

