/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.data;

import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataTypes;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public class DataUtil {
    public static String marshal(BIDataValue value) throws IOException {
        return DataUtil.marshal((BObject)((Object)value));
    }

    public static String marshal(BObject value) throws IOException {
        if (value == null) {
            return "null";
        }
        StringBuffer s = new StringBuffer();
        s.append(value.getType().getDataTypeSymbol());
        s.append(':');
        if (value instanceof BString) {
            s.append(SlotPath.escape(value.toString()));
        } else if (value instanceof BOrd) {
            s.append(SlotPath.escape(((BSimple)value).encodeToString()));
        } else {
            s.append(((BSimple)value).encodeToString());
        }
        return s.toString();
    }

    public static BObject unmarshal(String s) throws IOException {
        if (s.equals("null")) {
            return null;
        }
        char symbol = s.charAt(0);
        if (s.charAt(1) != ':') {
            throw new IOException("Expecting colon " + s);
        }
        String v = s.substring(2);
        Type type = DataTypes.getBySymbol(symbol);
        if (type == null) {
            throw new IOException("Unknown symbol " + symbol);
        }
        if (type == BString.TYPE) {
            return BString.make(SlotPath.unescape(v));
        }
        if (type == BOrd.TYPE) {
            BSimple simple = (BSimple)type.getInstance();
            return simple.decodeFromString(SlotPath.unescape(v));
        }
        BSimple simple = (BSimple)type.getInstance();
        return simple.decodeFromString(v);
    }
}

