/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.collection.ValueCollection;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;

public class PropertyMap
implements Map<Property, BValue> {
    private BComplex obj;

    public PropertyMap(BComplex obj) {
        this.obj = obj;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Property) {
            Property p = (Property)key;
            if (p.isFrozen()) {
                try {
                    this.obj.get((Property)key);
                    return true;
                }
                catch (NoSuchSlotException ex) {
                    return false;
                }
            }
            return this.obj.get(p.getName()) != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        SlotCursor<Property> c = this.obj.getProperties();
        while (c.next()) {
            if (!c.get().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Property, BValue>> entrySet() {
        HashSet<Map.Entry<Property, BValue>> entries = new HashSet<Map.Entry<Property, BValue>>();
        SlotCursor<Property> c = this.obj.getProperties();
        while (c.next()) {
            Property p = c.property();
            BValue v = c.get();
            entries.add(new AbstractMap.SimpleEntry<Property, BValue>(p, v));
        }
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PropertyMap) {
            return ((PropertyMap)o).obj.equals(this.obj);
        }
        return false;
    }

    @Override
    public BValue get(Object key) {
        if (key instanceof Property) {
            Property p = (Property)key;
            if (p.isFrozen()) {
                try {
                    return this.obj.get(p);
                }
                catch (NoSuchSlotException ex) {
                    return null;
                }
            }
            return this.obj.get(p.getName());
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.obj.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.obj.getPropertyCount() == 0;
    }

    @Override
    public Set<Property> keySet() {
        return new PropertySet(this.obj);
    }

    @Override
    public BValue put(Property property, BValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Property, ? extends BValue> toAdd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BValue remove(Object property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.obj.getPropertyCount();
    }

    @Override
    public Collection<BValue> values() {
        return new ValueCollection(this.obj);
    }

    public static class PropertySet
    implements Set<Property> {
        private BComplex obj;

        public PropertySet(BComplex obj) {
            this.obj = obj;
        }

        @Override
        public boolean add(Property p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Property> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Property)) {
                return false;
            }
            Property p = (Property)o;
            Property op = this.obj.getProperty(p.getName());
            return p == op;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PropertySet) {
                return ((PropertySet)o).obj == this.obj;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.obj.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.obj.getPropertyCount() == 0;
        }

        @Override
        public int size() {
            return this.obj.getPropertyCount();
        }

        @Override
        public Object[] toArray() {
            return this.obj.getPropertiesArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] result;
            try {
                System.arraycopy(this.obj.getPropertiesArray(), 0, a, 0, this.size());
                result = a;
            }
            catch (IndexOutOfBoundsException e) {
                Object[] temp = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
                System.arraycopy(this.obj.getPropertiesArray(), 0, temp, 0, this.size());
                result = temp;
            }
            return result;
        }

        @Override
        public Iterator<Property> iterator() {
            return SlotCursorIterator.stream(this.obj.getProperties(), Property.class).iterator();
        }
    }
}

