/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.authn;

import com.tridium.authn.BAuthenticationService;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.user.BUserPasswordConfiguration;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordHistory;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="globalPasswordConfiguration", type="baja:GlobalPasswordConfiguration", defaultValue="new BGlobalPasswordConfiguration()")})
public abstract class BPasswordAuthenticationScheme
extends BAuthenticationScheme {
    public static final Property globalPasswordConfiguration = BPasswordAuthenticationScheme.newProperty(0, new BGlobalPasswordConfiguration(), null);
    public static final Type TYPE = Sys.loadType(BPasswordAuthenticationScheme.class);
    public static final Logger log = Logger.getLogger(BAuthenticationService.class.getName());

    public BGlobalPasswordConfiguration getGlobalPasswordConfiguration() {
        return (BGlobalPasswordConfiguration)this.get(globalPasswordConfiguration);
    }

    public void setGlobalPasswordConfiguration(BGlobalPasswordConfiguration v) {
        this.set(globalPasswordConfiguration, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isDuplicatePassword(String password, BUser user) throws Exception {
        BUserPasswordConfiguration userConfig = ((BPasswordAuthenticator)user.getAuthenticator()).getPasswordConfig();
        BGlobalPasswordConfiguration serviceConfig = this.getGlobalPasswordConfiguration();
        BPasswordHistory history = userConfig.getPasswordHistory();
        int length = serviceConfig.getPasswordHistoryLength();
        return history.contains(user.getName(), BPassword.make(password, "plain.1"), length);
    }

    public boolean isDuplicatePassword(BPassword password, BUser user) throws Exception {
        return this.isDuplicatePassword(AccessController.doPrivileged(password::getValue), user);
    }

    public void checkPassword(String password) throws Exception {
        this.getGlobalPasswordConfiguration().getPasswordStrength().isPasswordValid(password);
    }

    public void checkPassword(BPassword password) throws Exception {
        this.checkPassword(AccessController.doPrivileged(password::getValue));
    }

    @Override
    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BPasswordAuthenticator();
    }
}

