/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.authn;

import com.tridium.authn.BAuthenticationService;
import com.tridium.nre.security.NullAlgorithmBundle;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@NiagaraSlots
public abstract class BAuthenticationScheme
extends BComponent
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BAuthenticationScheme.class);
    private static final Logger LOG = Logger.getLogger(BAuthenticationService.class.getName());

    @Override
    public Type getType() {
        return TYPE;
    }

    public abstract String getSchemeName();

    public abstract Configuration getLoginConfiguration();

    public final <T extends BIObject> T getAgentOn(Class<T> cls) {
        AgentInfo[] agentInfos;
        AgentList list = Sys.getRegistry().getSpecificAgents(this.getType().getTypeInfo());
        if (list == null || list.size() == 0) {
            return null;
        }
        AgentList filteredList = (AgentList)list.clone();
        for (AgentInfo agentInfo : agentInfos = filteredList.list()) {
            if (cls.isAssignableFrom(agentInfo.getInstance().getClass())) continue;
            filteredList.remove(agentInfo);
        }
        if (filteredList == null || filteredList.size() == 0) {
            return null;
        }
        AgentInfo info = filteredList.get(0);
        BObject instance = info.getInstance();
        return (T)instance;
    }

    public static BAuthenticationScheme getSchemeFromName(String schemeName) {
        AgentInfo[] agents;
        AgentList list = Sys.getRegistry().getSpecificAgents(TYPE.getTypeInfo());
        for (AgentInfo agent : agents = list.list()) {
            try {
                BAuthenticationScheme scheme;
                BObject obj;
                if (agent.getAgentType().isAbstract() || agent.getAgentType().isInterface() || !((obj = agent.getInstance()) instanceof BAuthenticationScheme) || !(scheme = (BAuthenticationScheme)obj).getSchemeName().equals(schemeName)) continue;
                return scheme;
            }
            catch (BajaRuntimeException bre) {
                if (!LOG.isLoggable(Level.INFO)) continue;
                String msg = "Failed to load " + agent.getAgentType();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.INFO, msg, bre);
                    continue;
                }
                LOG.info(msg);
            }
        }
        return null;
    }

    public boolean supportsRemoteUsers() {
        return false;
    }

    public String getKeyExchangeMethodName() {
        return NullAlgorithmBundle.getInstance().getAlgorithmName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginContext login(CallbackHandler handler) throws LoginException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LoginContext lc = null;
        try {
            BAuthenticationScheme.changeClassLoader(Thread.currentThread(), this.getClass().getClassLoader());
            lc = new LoginContext("", null, handler, this.getLoginConfiguration());
            lc.login();
        }
        finally {
            BAuthenticationScheme.changeClassLoader(Thread.currentThread(), cl);
        }
        return lc;
    }

    private static void changeClassLoader(Thread t, ClassLoader cl) {
        AccessController.doPrivileged(() -> {
            t.setContextClassLoader(cl);
            return null;
        });
    }

    public abstract BAbstractAuthenticator getDefaultAuthenticator();
}

