/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.authn;

import com.tridium.authn.BAuthenticationService;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Sys;

public final class AuthenticationUtil {
    public static final String SECURE_REQUIRED_MSG = "Secure Connection Required";
    public static final String LOCKOUT_MSG = "User Lockout";
    public static final String INVALID_CREDENTIALS_MSG = "Invalid Credentials";
    public static final String LOGIN_FAILED_MSG = "Login Failed";
    private static final BAuthenticationService authnService = (BAuthenticationService)Sys.getService(BAuthenticationService.TYPE);
    private static final Logger log = Logger.getLogger("authentication");

    private AuthenticationUtil() {
    }

    public static void debug(Level level, String message, Throwable t) {
        boolean serviceDebug = authnService != null && authnService.getDebug();
        boolean propDebug = "true".equals(AccessController.doPrivileged(() -> System.getProperty("javax.baja.authn.debug")));
        if (serviceDebug || propDebug) {
            log.log(level, message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

