/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.agent;

import java.util.function.Predicate;
import javax.baja.agent.AgentInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class AgentFilter {
    public static final AgentFilter all = new AgentFilter(){

        @Override
        public boolean include(AgentInfo agent) {
            return true;
        }
    };

    public abstract boolean include(AgentInfo var1);

    public static AgentFilter is(String agentTypeSpec) {
        return AgentFilter.is(Sys.getRegistry().getType(agentTypeSpec));
    }

    public static AgentFilter is(Type type) {
        return AgentFilter.is(type.getTypeInfo());
    }

    public static AgentFilter is(TypeInfo typeInfo) {
        return new IsFilter(typeInfo);
    }

    public static AgentFilter not(AgentFilter filter) {
        return new NotFilter(filter);
    }

    public static AgentFilter has(BPermissions permissions) {
        return new HasFilter(permissions);
    }

    public static AgentFilter and(AgentFilter f1, AgentFilter f2) {
        return new AndFilter(f1, f2);
    }

    public static AgentFilter and(AgentFilter filter, BPermissions permissions) {
        return AgentFilter.and(filter, AgentFilter.has(permissions));
    }

    public static AgentFilter or(AgentFilter f1, AgentFilter f2) {
        return new OrFilter(f1, f2, null, null);
    }

    public static AgentFilter or(AgentFilter f1, AgentFilter f2, AgentFilter f3) {
        return new OrFilter(f1, f2, f3, null);
    }

    public static AgentFilter or(AgentFilter f1, AgentFilter f2, AgentFilter f3, AgentFilter f4) {
        return new OrFilter(f1, f2, f3, f4);
    }

    public Predicate<AgentInfo> toPredicate() {
        return this::include;
    }

    static class OrFilter
    extends AgentFilter {
        AgentFilter f1;
        AgentFilter f2;
        AgentFilter f3;
        AgentFilter f4;

        OrFilter(AgentFilter f1, AgentFilter f2, AgentFilter f3, AgentFilter f4) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
        }

        @Override
        public final boolean include(AgentInfo agent) {
            if (this.f1 != null && this.f1.include(agent)) {
                return true;
            }
            if (this.f2 != null && this.f2.include(agent)) {
                return true;
            }
            if (this.f3 != null && this.f3.include(agent)) {
                return true;
            }
            return this.f4 != null && this.f4.include(agent);
        }
    }

    static class AndFilter
    extends AgentFilter {
        AgentFilter f1;
        AgentFilter f2;

        AndFilter(AgentFilter f1, AgentFilter f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public final boolean include(AgentInfo agent) {
            return this.f1.include(agent) && this.f2.include(agent);
        }
    }

    static class HasFilter
    extends AgentFilter {
        BPermissions p;

        HasFilter(BPermissions p) {
            this.p = p;
        }

        @Override
        public final boolean include(AgentInfo agent) {
            try {
                return this.p.has(agent.getRequiredPermissions());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    static class NotFilter
    extends AgentFilter {
        AgentFilter f;

        NotFilter(AgentFilter t) {
            this.f = t;
        }

        @Override
        public final boolean include(AgentInfo agent) {
            return !this.f.include(agent);
        }
    }

    static class IsFilter
    extends AgentFilter {
        TypeInfo t;

        IsFilter(TypeInfo t) {
            this.t = t;
        }

        @Override
        public final boolean include(AgentInfo agent) {
            return agent.getAgentType().is(this.t);
        }
    }
}

