/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.jar;

import com.tridium.util.jar.ModuleFile;
import com.tridium.util.jar.ModuleURLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;

public class ModuleEntry
extends JarEntry {
    final ModuleFile moduleFile;
    final JarEntry entry;

    public ModuleEntry(ModuleFile moduleFile, JarEntry entry) {
        super(entry.getName());
        this.moduleFile = moduleFile;
        this.entry = entry;
        this.setSize(entry.getSize());
        this.setTime(entry.getTime());
    }

    public InputStream getInputStream() throws IOException {
        return this.moduleFile.zip.getInputStream(this.entry);
    }

    public byte[] read() throws IOException {
        int len = (int)this.getSize();
        byte[] buf = new byte[len];
        try (InputStream in = this.getInputStream();){
            int n;
            for (int count = 0; count < len; count += n) {
                n = in.read(buf, count, len - count);
                if (n >= 0) continue;
                throw new IOException("Unexpected EOF");
            }
        }
        return buf;
    }

    public URL getURL() {
        String fullPath = this.moduleFile.url + "!/" + this.getName();
        return AccessController.doPrivileged(() -> {
            try {
                return new URL("jar", "", -1, fullPath, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new ModuleURLConnection(u, ModuleEntry.this);
                    }
                });
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    @Override
    public Certificate[] getCertificates() {
        return this.entry.getCertificates();
    }

    @Override
    public Attributes getAttributes() throws IOException {
        return this.entry.getAttributes();
    }

    @Override
    public CodeSigner[] getCodeSigners() {
        return this.entry.getCodeSigners();
    }
}

