/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Calendar;
import java.util.HashMap;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class TimeFormat {
    static final int SHOW_DATE = 1;
    static final int SHOW_TIME = 2;
    static final int SHOW_SECONDS = 4;
    static final int SHOW_MILLIS = 8;
    static final int SHOW_ZONE = 16;
    static final int[] SHOW = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 12, 16, 1, 1, 1, 16, 1};
    public static final int YEAR_2 = 1;
    public static final int YEAR_4 = 2;
    public static final int MON_1 = 3;
    public static final int MON_2 = 4;
    public static final int MON_TAG = 5;
    public static final int MON = 18;
    public static final int DAY_1 = 6;
    public static final int DAY_2 = 7;
    public static final int HOUR_12_1 = 8;
    public static final int HOUR_12_2 = 9;
    public static final int HOUR_24_1 = 10;
    public static final int HOUR_24_2 = 11;
    public static final int MIN = 12;
    public static final int AM_PM = 13;
    public static final int SEC = 14;
    public static final int ZONE_TAG = 15;
    public static final int WEEK_1 = 16;
    public static final int WEEK_2 = 17;
    public static final int ZONE_OFFSET = 19;
    public static final int WEEK_YEAR = 20;
    private static String[] PATTERNS = new String[]{"?", "YY", "YYYY", "M", "MM", "MMM", "D", "DD", "h", "hh", "H", "HH", "mm", "a", "ss", "z", "W", "WW", "MMMM", "Z", "w"};
    static HashMap<String, TimeFormat> cache = new HashMap();
    static String defaultPattern = null;
    static final String fallbackPattern = "DD-MMM-YY h:mm:ss a z";
    public static final String TIME_FORMAT = "timeFormat";
    int[] pattern;

    public static String format(BAbsTime time, String pattern, Context cx) {
        cx = BFacets.make(cx.getFacets(), BFacets.make(TIME_FORMAT, BString.make(pattern)));
        return TimeFormat.format(time, cx);
    }

    public static String format(BAbsTime time, String pattern) {
        BFacets cx = BFacets.make(TIME_FORMAT, BString.make(pattern));
        return TimeFormat.format(time, (Context)cx);
    }

    public static String format(BAbsTime time, Context cx) {
        time = TimeFormat.toTimeZone(time, cx);
        int show = TimeFormat.toShowMask(19, cx);
        show = TimeFormat.normalizeShowMask(show);
        return TimeFormat.make(cx).format(time, show, cx);
    }

    public static String formatTime(BAbsTime time, Context cx) {
        time = TimeFormat.toTimeZone(time, cx);
        int show = TimeFormat.toShowMask(2, cx);
        show |= 2;
        show &= 0xFFFFFFFE;
        show = TimeFormat.normalizeShowMask(show);
        return TimeFormat.make(cx).format(time, show, cx);
    }

    public static String formatDate(BAbsTime time, Context cx) {
        time = TimeFormat.toTimeZone(time, cx);
        int show = TimeFormat.toShowMask(1, cx);
        show |= 1;
        show &= 0xFFFFFFFD;
        show = TimeFormat.normalizeShowMask(show);
        return TimeFormat.make(cx).format(time, show, cx);
    }

    public static String format(BTime time, Context cx) {
        int show = TimeFormat.toShowMask(2, cx);
        show &= 0xFFFFFFFE;
        show &= 0xFFFFFFEF;
        show = TimeFormat.normalizeShowMask(show);
        return TimeFormat.make(cx).format(time, show, cx);
    }

    public static int[] pattern(Context cx) {
        int show = TimeFormat.toShowMask(19, cx);
        return TimeFormat.make(cx).pattern(show);
    }

    public static void setDefaultPattern(String pattern) {
        if (pattern != null && (pattern = pattern.trim()).length() == 0) {
            pattern = null;
        }
        defaultPattern = pattern;
    }

    private static BAbsTime toTimeZone(BAbsTime time, Context cx) {
        BTimeZone timeZone;
        if (cx != null && (timeZone = (BTimeZone)cx.getFacet("TimeZone")) != null) {
            return BAbsTime.make(time, timeZone);
        }
        return time;
    }

    static TimeFormat make(Context cx) {
        TimeFormat format;
        BObject timeFormat;
        String pattern = null;
        if (cx != null && (timeFormat = cx.getFacet(TIME_FORMAT)) != null) {
            pattern = ((Object)timeFormat).toString();
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = defaultPattern;
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = Lexicon.make(Sys.getBajaModule(), cx).get(TIME_FORMAT);
        }
        if (pattern == null || pattern.length() == 0) {
            System.out.println("ERROR: Missing baja:timeFormat lexicon entry");
            pattern = fallbackPattern;
        }
        if ((format = cache.get(pattern)) == null) {
            format = new TimeFormat(pattern);
            cache.put(pattern, format);
        }
        return format;
    }

    TimeFormat(String textPattern) {
        if (textPattern == null) {
            textPattern = fallbackPattern;
        }
        int len = textPattern.length();
        int[] pattern = new int[len];
        int n = 0;
        char last = textPattern.charAt(0);
        int count = 1;
        for (int i = 1; i < len; ++i) {
            char c = textPattern.charAt(i);
            if (last == c) {
                ++count;
                continue;
            }
            pattern[n++] = this.toCode(last, count);
            last = c;
            count = 1;
        }
        pattern[n++] = this.toCode(last, count);
        this.pattern = new int[n];
        System.arraycopy(pattern, 0, this.pattern, 0, n);
    }

    int toCode(int c, int count) {
        switch (c) {
            case 89: {
                return count <= 2 ? 1 : 2;
            }
            case 77: {
                switch (count) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                }
                return 18;
            }
            case 68: {
                return count == 1 ? 6 : 7;
            }
            case 104: {
                return count == 1 ? 8 : 9;
            }
            case 72: {
                return count == 1 ? 10 : 11;
            }
            case 109: {
                return 12;
            }
            case 115: {
                return 14;
            }
            case 97: {
                return 13;
            }
            case 122: {
                return 15;
            }
            case 90: {
                return 19;
            }
            case 87: {
                return count == 1 ? 16 : 17;
            }
            case 119: {
                return 20;
            }
        }
        return c;
    }

    int[] pattern(int show) {
        int[] result = new int[this.pattern.length];
        int n = 0;
        int sep = -1;
        int shownCount = 0;
        for (int i = 0; i < this.pattern.length; ++i) {
            int c = this.pattern[i];
            if (c >= SHOW.length) {
                sep = c;
                continue;
            }
            if ((SHOW[c] & show) == 0) {
                sep = -1;
                continue;
            }
            if (++shownCount > 1 && sep != -1) {
                result[n++] = sep;
                sep = -1;
            }
            ++shownCount;
            result[n++] = c;
        }
        int[] trim = new int[n];
        System.arraycopy(result, 0, trim, 0, n);
        return trim;
    }

    String format(BTime t, int show, Context cx) {
        return this.format(null, 0, BMonth.january, 0, t.getHour(), t.getMinute(), t.getSecond(), t.getMillisecond(), BTimeZone.getLocal(), show, cx);
    }

    String format(BAbsTime t, int show, Context cx) {
        return this.format(t, t.getYear(), t.getMonth(), t.getDay(), t.getHour(), t.getMinute(), t.getSecond(), t.getMillisecond(), t.getTimeZone(), show, cx);
    }

    String format(BAbsTime t, int year, BMonth month, int day, int hour, int min, int sec, int millis, BTimeZone timeZone, int show, Context cx) {
        int mon = month.getOrdinal() + 1;
        int[] pattern = this.pattern;
        int patternLength = pattern.length;
        StringBuffer s = new StringBuffer(patternLength * 4);
        int sep1 = -1;
        int sep2 = -1;
        int shownCount = 0;
        for (int i = 0; i < patternLength; ++i) {
            int c = pattern[i];
            if (c >= SHOW.length) {
                if (sep1 == -1) {
                    sep1 = c;
                    continue;
                }
                if (sep2 != -1) continue;
                sep2 = c;
                continue;
            }
            if ((SHOW[c] & show) == 0) {
                sep2 = -1;
                sep1 = -1;
                continue;
            }
            if (++shownCount > 1 && sep1 != -1) {
                s.append((char)sep1);
                if (sep2 != -1) {
                    s.append((char)sep2);
                }
                sep2 = -1;
                sep1 = -1;
            }
            ++shownCount;
            switch (c) {
                case 1: {
                    TimeFormat.pad(s, year % 100);
                    break;
                }
                case 2: {
                    s.append(year);
                    break;
                }
                case 3: {
                    s.append(mon);
                    break;
                }
                case 4: {
                    TimeFormat.pad(s, mon);
                    break;
                }
                case 5: {
                    s.append(month.getShortDisplayTag(cx));
                    break;
                }
                case 18: {
                    s.append(month.toString(cx));
                    break;
                }
                case 6: {
                    s.append(day);
                    break;
                }
                case 7: {
                    TimeFormat.pad(s, day);
                    break;
                }
                case 8: {
                    if (hour == 0) {
                        s.append("12");
                        break;
                    }
                    s.append(hour > 12 ? hour - 12 : hour);
                    break;
                }
                case 9: {
                    if (hour == 0) {
                        s.append("12");
                        break;
                    }
                    TimeFormat.pad(s, hour > 12 ? hour - 12 : hour);
                    break;
                }
                case 10: {
                    s.append(hour);
                    break;
                }
                case 11: {
                    TimeFormat.pad(s, hour);
                    break;
                }
                case 12: {
                    TimeFormat.pad(s, min);
                    break;
                }
                case 13: {
                    s.append(hour < 12 ? "AM" : "PM");
                    break;
                }
                case 14: {
                    TimeFormat.pad(s, sec);
                    if ((show & 8) == 0) break;
                    s.append('.');
                    if (millis < 10) {
                        s.append('0');
                    }
                    if (millis < 100) {
                        s.append('0');
                    }
                    s.append(millis);
                    break;
                }
                case 15: {
                    s.append(timeZone.getShortDisplayName(t, cx));
                    break;
                }
                case 19: {
                    int offset = t != null ? t.getTimeZoneOffset() : timeZone.getUtcOffset();
                    if (offset == 0) {
                        s.append('Z');
                        break;
                    }
                    int hrOff = Math.abs(offset / 3600000);
                    int minOff = Math.abs(offset % 3600000 / 60000);
                    if (offset < 0) {
                        s.append('-');
                    } else {
                        s.append('+');
                    }
                    if (hrOff < 10) {
                        s.append('0');
                    }
                    s.append(hrOff);
                    s.append(":");
                    if (minOff < 10) {
                        s.append('0');
                    }
                    s.append(minOff);
                    break;
                }
                case 16: {
                    s.append(t.getWeekday().getShortDisplayTag(cx));
                    break;
                }
                case 17: {
                    s.append(t.getWeekday().getDisplayTag(cx));
                    break;
                }
                case 20: {
                    Calendar calendar = BAbsTime.makeCalendar(year, month, day, hour, min, sec, millis, timeZone, cx);
                    s.append(calendar.get(3));
                }
            }
            sep2 = -1;
            sep1 = -1;
        }
        return s.toString();
    }

    static void pad(StringBuffer s, int num) {
        if (num < 10) {
            s.append('0');
        }
        s.append(num);
    }

    static int toShowMask(int mask, Context cx) {
        if (cx != null) {
            BFacets f = cx.getFacets();
            mask = TimeFormat.mask(mask, f, "showDate", 1);
            mask = TimeFormat.mask(mask, f, "showTime", 2);
            mask = TimeFormat.mask(mask, f, "showSeconds", 4);
            mask = TimeFormat.mask(mask, f, "showMilliseconds", 8);
            mask = TimeFormat.mask(mask, f, "showTimeZone", 16);
        }
        return mask;
    }

    static int mask(int working, BFacets facets, String key, int bit) {
        BObject value = facets.getFacet(key);
        if (value instanceof BBoolean) {
            working = ((BBoolean)value).getBoolean() ? (working |= bit) : (working &= ~bit);
        }
        return working;
    }

    static int normalizeShowMask(int mask) {
        if ((mask & 2) == 0) {
            mask &= 0xFFFFFFE3;
        }
        return mask;
    }

    public static String patternToString(int p) {
        if (p < PATTERNS.length) {
            return PATTERNS[p];
        }
        return "" + (char)p;
    }

    public static String patternToString(int[] p) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < p.length; ++i) {
            s.append(TimeFormat.patternToString(p[i]));
        }
        return s.toString();
    }
}

