/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.baja.io.BajaIOException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Localizable;
import javax.baja.xml.XException;

public class ThrowableUtil {
    static final int DEFAULT_STACK_DEPTH = 20;

    public static RuntimeException toRuntime(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new BajaRuntimeException(ex);
    }

    public static Throwable getCause(Throwable ex) {
        if (ex instanceof BajaException) {
            return ex.getCause();
        }
        if (ex instanceof BajaRuntimeException) {
            return ex.getCause();
        }
        if (ex instanceof BajaIOException) {
            return ex.getCause();
        }
        if (ex instanceof XException) {
            return ex.getCause();
        }
        if (ex instanceof InvocationTargetException) {
            return ((InvocationTargetException)ex).getTargetException();
        }
        if (ex instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)ex).getException();
        }
        return null;
    }

    public static String getStack() {
        return ThrowableUtil.dumpToString(new Exception());
    }

    public static String dumpToString(Throwable ex) {
        StringWriter out = new StringWriter();
        ThrowableUtil.dump(out, ex, 0, 20);
        return out.toString();
    }

    public static String dumpToString(Throwable ex, int stackDepth) {
        StringWriter out = new StringWriter();
        ThrowableUtil.dump(out, ex, 0, stackDepth);
        return out.toString();
    }

    public static void dump(Writer out, Throwable ex) {
        ThrowableUtil.dump(out, ex, 0, 20);
    }

    public static void dump(Writer out, Throwable ex, int stackDepth) {
        ThrowableUtil.dump(out, ex, 0, stackDepth);
    }

    public static void dump(Throwable ex) {
        ThrowableUtil.dump(System.out, ex);
    }

    public static void dump(OutputStream out, Throwable ex) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            ThrowableUtil.dump(writer, ex, 0, 20);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void dump(Writer out, Throwable ex, int indent, int depth) {
        try {
            String line;
            if (ex == null) {
                return;
            }
            StringWriter sout = new StringWriter();
            PrintWriter pout = new PrintWriter(sout);
            ex.printStackTrace(pout);
            pout.flush();
            BufferedReader in = new BufferedReader(new StringReader(sout.toString()));
            for (int i = 0; i < depth && (line = in.readLine()) != null; ++i) {
                out.write(TextUtil.getSpaces((int)(indent * 2)));
                int len = line.length();
                for (int j = 0; j < len; ++j) {
                    char c = line.charAt(j);
                    if (c == '\t') {
                        out.write("   ");
                        continue;
                    }
                    out.write(c);
                }
                out.write(10);
            }
            Throwable cause = ThrowableUtil.getCause(ex);
            if (cause != null) {
                ThrowableUtil.dump(out, cause, indent + 1, depth);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Localizable toLocalizable(Throwable details) {
        if (details == null) {
            return null;
        }
        if (details instanceof Localizable) {
            return (Localizable)((Object)details);
        }
        return ThrowableUtil.toLocalizable(ThrowableUtil.getCause(details));
    }

    public static Optional<SecurityException> toSecurity(Throwable details) {
        if (details == null) {
            return Optional.empty();
        }
        if (details instanceof SecurityException) {
            return Optional.of((SecurityException)details);
        }
        return ThrowableUtil.toSecurity(details.getCause());
    }
}

