/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class PxUtil {
    static final TypeInfo pxEditor = PxUtil.typeInfo("pxEditor:PxEditor");
    static final TypeInfo hxView = PxUtil.typeInfo("hx:HxView");
    static final TypeInfo hxPxView = PxUtil.typeInfo("hx:HxPxView");
    static final TypeInfo pdf = PxUtil.typeInfo("pdf:PxViewToPdf");
    static TypeInfo[] emptyTypeInfo = new TypeInfo[0];
    static final BIcon editorBadge = BIcon.std("badges/edit.png");

    public static AgentList explode(AgentList list) {
        AgentInfo[] agents = list.list();
        int exportIndex = 0;
        for (int i = 0; i < agents.length; ++i) {
            AgentInfo agent = agents[i];
            if (!(agent instanceof BAbstractPxView)) continue;
            BAbstractPxView view = (BAbstractPxView)agent;
            if (pxEditor != null) {
                list.add(list.size(), new PxEditor(view));
            }
            if (hxView != null) {
                AgentList agentList = view.getAgents();
                agentList = agentList.filter(AgentFilter.is(hxView));
                TypeInfo typeInfo = agentList.getDefault().getAgentType();
                list.add(exportIndex++, new PxHx(view, typeInfo));
            }
            if (pdf == null) continue;
            list.add(list.size(), new PxPdf(view));
        }
        return list;
    }

    public static TypeInfo typeInfo(String typeSpec) {
        try {
            return Sys.getRegistry().getType(typeSpec);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static class PxPdf
    extends PxExporter {
        public PxPdf(BAbstractPxView view) {
            super(view, "pdf", pdf);
        }
    }

    public static class PxMobile
    extends PxExporter {
        public PxMobile(BAbstractPxView pxView, TypeInfo mobileView) {
            super(pxView, "mobile", mobileView);
        }
    }

    public static class PxHx
    extends PxExporter {
        public PxHx(BAbstractPxView pxView, TypeInfo hxView) {
            super(pxView, "hx", hxView);
        }

        public PxHx(BAbstractPxView pxView) {
            super(pxView, "hx", hxPxView);
        }
    }

    public static class PxExporter
    extends PxAgent {
        PxExporter(BAbstractPxView view, String subId, TypeInfo agentType) {
            super(view, subId, agentType);
        }

        @Override
        public BIcon getIcon(Context cx) {
            return BIcon.std("files/" + this.subId + ".png");
        }

        @Override
        public BPermissions getRequiredPermissions() {
            return this.pxView.getRequiredPermissions();
        }
    }

    public static class PxEditor
    extends PxAgent {
        PxEditor(BAbstractPxView view) {
            super(view, "editor", pxEditor);
        }

        @Override
        public BIcon getIcon(Context cx) {
            return BIcon.make(this.pxView.getIcon(), editorBadge);
        }

        @Override
        public BPermissions getRequiredPermissions() {
            return BPermissions.adminWrite;
        }
    }

    public static abstract class PxAgent
    implements AgentInfo {
        BAbstractPxView pxView;
        String subId;
        TypeInfo agentType;

        public PxAgent(BAbstractPxView pxView, String subId, TypeInfo agentType) {
            this.pxView = pxView;
            this.subId = subId;
            this.agentType = agentType;
        }

        @Override
        public BObject getInstance() {
            try {
                Class<?> cls = this.agentType.getTypeSpec().getResolvedType().getTypeClass();
                Constructor<?> ctor = cls.getConstructor(BAbstractPxView.class);
                return (BObject)ctor.newInstance(this.pxView);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new BajaRuntimeException(cause);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BajaRuntimeException(e);
            }
        }

        public final BAbstractPxView getPxView() {
            return this.pxView;
        }

        @Override
        public final String getAgentId() {
            return this.pxView.getName() + "/" + this.subId;
        }

        @Override
        public final TypeInfo getAgentType() {
            return this.agentType;
        }

        @Override
        public final String getAppName() {
            return null;
        }

        @Override
        public TypeInfo[] getAgentOn() {
            return emptyTypeInfo;
        }

        @Override
        public String getDisplayName(Context cx) {
            Object[] args = new Object[]{this.pxView.getDisplayName(cx)};
            return Lexicon.make("baja", cx).getText("px." + this.subId, args);
        }

        public String toString() {
            return this.pxView.getName() + " as " + TextUtil.getClassName(this.getClass());
        }
    }
}

