/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MapUtil {
    public static <K, V> ComparisonResults<V> compare(Iterable<V> beforeList, Iterable<V> afterList, Function<V, K> keyAccessor) {
        return MapUtil.compare(beforeList, afterList, keyAccessor, Object::equals);
    }

    public static <V> ComparisonResults<V> compare(Iterable<V> beforeList, Iterable<V> afterList) {
        return MapUtil.compare(beforeList, afterList, o -> o, Object::equals);
    }

    public static <K, V> ComparisonResults<V> compare(Iterable<V> beforeList, Iterable<V> afterList, Function<V, K> keyAccessor, BiFunction<V, V, Boolean> valueMatchesFunction) {
        HashMap beforeMap = new HashMap();
        if (beforeList != null) {
            beforeList.forEach(value -> beforeMap.put(keyAccessor.apply(value), value));
        }
        HashMap afterMap = new HashMap();
        if (afterList != null) {
            afterList.forEach(value -> afterMap.put(keyAccessor.apply(value), value));
        }
        return MapUtil.compare(beforeMap, afterMap, valueMatchesFunction);
    }

    public static <K, V> ComparisonResults<V> compare(Map<K, V> beforeMap, Map<K, V> afterMap) {
        return MapUtil.compare(beforeMap, afterMap, Object::equals);
    }

    public static <K, V> ComparisonResults<V> compare(Map<K, V> beforeMap, Map<K, V> afterMap, BiFunction<V, V, Boolean> valueMatchesFunction) {
        ComparisonResults results = new ComparisonResults();
        if (beforeMap == null) {
            if (afterMap == null) {
                return results;
            }
            results.added.addAll(afterMap.values());
            return results;
        }
        if (afterMap == null) {
            results.removed.addAll(beforeMap.values());
            return results;
        }
        HashSet<K> removedKeys = new HashSet<K>(beforeMap.keySet());
        removedKeys.removeAll(afterMap.keySet());
        removedKeys.forEach(key -> results.removed.add(beforeMap.get(key)));
        HashSet<K> addedKeys = new HashSet<K>(afterMap.keySet());
        addedKeys.removeAll(beforeMap.keySet());
        addedKeys.forEach(key -> results.added.add(afterMap.get(key)));
        HashSet<K> commonKeys = new HashSet<K>(afterMap.keySet());
        commonKeys.retainAll(beforeMap.keySet());
        commonKeys.forEach(key -> {
            if (((Boolean)valueMatchesFunction.apply(afterMap.get(key), beforeMap.get(key))).booleanValue()) {
                results.unchanged.add(afterMap.get(key));
            } else {
                results.updated.add(afterMap.get(key));
            }
        });
        return results;
    }

    public static class ComparisonResults<T> {
        public List<T> added = new ArrayList<T>();
        public List<T> updated = new ArrayList<T>();
        public List<T> removed = new ArrayList<T>();
        public List<T> unchanged = new ArrayList<T>();

        public final boolean matchesExactly() {
            return this.added.size() == 0 && this.updated.size() == 0 && this.removed.size() == 0;
        }
    }
}

