/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.IFoxSession;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;

public final class HistoryCategoryUtil {
    private HistoryCategoryUtil() {
    }

    public static BCategoryMask getCategoryMask(BOrd ord, String stationName) {
        BCategoryService service = BCategoryService.getService();
        BCategoryMask mask = service.getOrdMap().getCategoryMask(ord);
        if (mask != null) {
            return mask;
        }
        return service.getCategoryMask(HistoryCategoryUtil.convertToShorthand(ord, stationName));
    }

    public static BCategoryMask getAppliedCategoryMask(BOrd ord, String stationName) {
        BCategoryService service = BCategoryService.getService();
        BOrd shorthandOrd = HistoryCategoryUtil.convertToShorthand(ord, stationName);
        BCategoryMask mask = service.getOrdMap().getAppliedCategoryMask(shorthandOrd);
        if (mask == null) {
            BOrd nonShorthandOrd;
            String s = TextUtil.toLowerCase((String)ord.relativizeToSession().toString());
            if (s.startsWith("history:^")) {
                String localHistoryDevice = "history:/" + TextUtil.toLowerCase((String)stationName);
                s = s.length() > 9 ? localHistoryDevice + '/' + s.substring(9) : localHistoryDevice;
            }
            if ((nonShorthandOrd = BOrd.make(s)).equals(shorthandOrd)) {
                nonShorthandOrd = null;
            }
            mask = service.getAppliedCategoryMask(nonShorthandOrd);
        }
        return mask;
    }

    public static BOrd convertToShorthand(BOrd ord, String stationName) {
        String localHistoryDevice;
        String s = TextUtil.toLowerCase((String)ord.relativizeToSession().toString());
        if (s.startsWith(localHistoryDevice = "history:/" + TextUtil.toLowerCase((String)stationName) + '/')) {
            s = "history:^" + s.substring(localHistoryDevice.length());
        }
        return BOrd.make(s);
    }

    public static BCategoryMask getOrdMapCategoryMask(BOrd categorizableOrd, BCategoryService service) {
        String s;
        BISession session;
        BCategoryMask mask = service.getOrdMap().getCategoryMask(categorizableOrd);
        if (mask == null && (session = BOrd.toSession(service)) instanceof IFoxSession && (s = TextUtil.toLowerCase((String)categorizableOrd.relativizeToSession().encodeToString())).startsWith("history:")) {
            mask = service.getOrdMap().getCategoryMask(HistoryCategoryUtil.convertToShorthand(categorizableOrd, ((IFoxSession)((Object)session)).getStationName()));
        }
        return mask;
    }
}

